// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details and path tracking information for a single time a person's path is tracked in a video. Amazon Rekognition operations that track people's paths return an array of `PersonDetection` objects with elements for each time a person's path is tracked in a video.
 *
 * For more information, see GetPersonTracking in the Amazon Rekognition Developer Guide.
 */
public class PersonDetection private constructor(builder: Builder) {
    /**
     * Details about a person whose path was tracked in a video.
     */
    public val person: aws.sdk.kotlin.services.rekognition.model.PersonDetail? = builder.person
    /**
     * The time, in milliseconds from the start of the video, that the person's path was tracked. Note that `Timestamp` is not guaranteed to be accurate to the individual frame where the person's path first appears.
     */
    public val timestamp: kotlin.Long = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.PersonDetection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PersonDetection(")
        append("person=$person,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = person?.hashCode() ?: 0
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PersonDetection

        if (person != other.person) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.PersonDetection = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Details about a person whose path was tracked in a video.
         */
        public var person: aws.sdk.kotlin.services.rekognition.model.PersonDetail? = null
        /**
         * The time, in milliseconds from the start of the video, that the person's path was tracked. Note that `Timestamp` is not guaranteed to be accurate to the individual frame where the person's path first appears.
         */
        public var timestamp: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.PersonDetection) : this() {
            this.person = x.person
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.PersonDetection = PersonDetection(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.PersonDetail] inside the given [block]
         */
        public fun person(block: aws.sdk.kotlin.services.rekognition.model.PersonDetail.Builder.() -> kotlin.Unit) {
            this.person = aws.sdk.kotlin.services.rekognition.model.PersonDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
