// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the results for a media analysis job created with StartMediaAnalysisJob.
 */
public class MediaAnalysisResults private constructor(builder: Builder) {
    /**
     * Information about the model versions for the features selected in a given job.
     */
    public val modelVersions: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisModelVersions? = builder.modelVersions
    /**
     * Provides the S3 bucket name and object name.
     *
     * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
     *
     * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
     */
    public val s3Object: aws.sdk.kotlin.services.rekognition.model.S3Object? = builder.s3Object

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaAnalysisResults(")
        append("modelVersions=$modelVersions,")
        append("s3Object=$s3Object")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = modelVersions?.hashCode() ?: 0
        result = 31 * result + (s3Object?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaAnalysisResults

        if (modelVersions != other.modelVersions) return false
        if (s3Object != other.s3Object) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the model versions for the features selected in a given job.
         */
        public var modelVersions: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisModelVersions? = null
        /**
         * Provides the S3 bucket name and object name.
         *
         * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
         *
         * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
         */
        public var s3Object: aws.sdk.kotlin.services.rekognition.model.S3Object? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults) : this() {
            this.modelVersions = x.modelVersions
            this.s3Object = x.s3Object
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults = MediaAnalysisResults(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisModelVersions] inside the given [block]
         */
        public fun modelVersions(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisModelVersions.Builder.() -> kotlin.Unit) {
            this.modelVersions = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisModelVersions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.S3Object] inside the given [block]
         */
        public fun s3Object(block: aws.sdk.kotlin.services.rekognition.model.S3Object.Builder.() -> kotlin.Unit) {
            this.s3Object = aws.sdk.kotlin.services.rekognition.model.S3Object.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
