// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains settings that specify the location of an Amazon S3 bucket used to store the output of a Face Liveness session. Note that the S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system.
 */
public class LivenessOutputConfig private constructor(builder: Builder) {
    /**
     * The path to an AWS Amazon S3 bucket used to store Face Liveness session results.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The prefix prepended to the output files for the Face Liveness session results.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LivenessOutputConfig(")
        append("s3Bucket=$s3Bucket,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket.hashCode()
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LivenessOutputConfig

        if (s3Bucket != other.s3Bucket) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path to an AWS Amazon S3 bucket used to store Face Liveness session results.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The prefix prepended to the output files for the Face Liveness session results.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig = LivenessOutputConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
