// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the starting point in a Kinesis stream to start processing. You can use the producer timestamp or the fragment number. One of either producer timestamp or fragment number is required. If you use the producer timestamp, you must put the time in milliseconds. For more information about fragment numbers, see [Fragment](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html).
 */
public class KinesisVideoStreamStartSelector private constructor(builder: Builder) {
    /**
     * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     */
    public val fragmentNumber: kotlin.String? = builder.fragmentNumber
    /**
     * The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time format.
     */
    public val producerTimestamp: kotlin.Long? = builder.producerTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.KinesisVideoStreamStartSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisVideoStreamStartSelector(")
        append("fragmentNumber=$fragmentNumber,")
        append("producerTimestamp=$producerTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fragmentNumber?.hashCode() ?: 0
        result = 31 * result + (producerTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisVideoStreamStartSelector

        if (fragmentNumber != other.fragmentNumber) return false
        if (producerTimestamp != other.producerTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.KinesisVideoStreamStartSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
         */
        public var fragmentNumber: kotlin.String? = null
        /**
         * The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time format.
         */
        public var producerTimestamp: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.KinesisVideoStreamStartSelector) : this() {
            this.fragmentNumber = x.fragmentNumber
            this.producerTimestamp = x.producerTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.KinesisVideoStreamStartSelector = KinesisVideoStreamStartSelector(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
