// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class IndexFacesRequest private constructor(builder: Builder) {
    /**
     * The ID of an existing collection to which you want to add the faces that are detected in the input images.
     */
    public val collectionId: kotlin.String? = builder.collectionId
    /**
     * An array of facial attributes you want to be returned. A `DEFAULT` subset of facial attributes - `BoundingBox`, `Confidence`, `Pose`, `Quality`, and `Landmarks` - will always be returned. You can request for specific facial attributes (in addition to the default list) - by using `["DEFAULT", "FACE_OCCLUDED"]` or just `["FACE_OCCLUDED"]`. You can request for all facial attributes by using `["ALL"]`. Requesting more attributes may increase response time.
     *
     * If you provide both, `["ALL", "DEFAULT"]`, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes).
     */
    public val detectionAttributes: List<Attribute>? = builder.detectionAttributes
    /**
     * The ID you want to assign to all the faces detected in the image.
     */
    public val externalImageId: kotlin.String? = builder.externalImageId
    /**
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image
    /**
     * The maximum number of faces to index. The value of `MaxFaces` must be greater than or equal to 1. `IndexFaces` returns no more than 100 detected faces in an image, even if you specify a larger value for `MaxFaces`.
     *
     * If `IndexFaces` detects more faces than the value of `MaxFaces`, the faces with the lowest quality are filtered out first. If there are still more faces than the value of `MaxFaces`, the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of `MaxFaces`). Information about the unindexed faces is available in the `UnindexedFaces` array.
     *
     * The faces that are returned by `IndexFaces` are sorted by the largest face bounding box size to the smallest size, in descending order.
     *
     * `MaxFaces` can be used with a collection associated with any version of the face model.
     */
    public val maxFaces: kotlin.Int? = builder.maxFaces
    /**
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't indexed. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The default value is `AUTO`. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed.
     *
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
     */
    public val qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = builder.qualityFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.IndexFacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexFacesRequest(")
        append("collectionId=$collectionId,")
        append("detectionAttributes=$detectionAttributes,")
        append("externalImageId=$externalImageId,")
        append("image=$image,")
        append("maxFaces=$maxFaces,")
        append("qualityFilter=$qualityFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionId?.hashCode() ?: 0
        result = 31 * result + (detectionAttributes?.hashCode() ?: 0)
        result = 31 * result + (externalImageId?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (maxFaces ?: 0)
        result = 31 * result + (qualityFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexFacesRequest

        if (collectionId != other.collectionId) return false
        if (detectionAttributes != other.detectionAttributes) return false
        if (externalImageId != other.externalImageId) return false
        if (image != other.image) return false
        if (maxFaces != other.maxFaces) return false
        if (qualityFilter != other.qualityFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.IndexFacesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of an existing collection to which you want to add the faces that are detected in the input images.
         */
        public var collectionId: kotlin.String? = null
        /**
         * An array of facial attributes you want to be returned. A `DEFAULT` subset of facial attributes - `BoundingBox`, `Confidence`, `Pose`, `Quality`, and `Landmarks` - will always be returned. You can request for specific facial attributes (in addition to the default list) - by using `["DEFAULT", "FACE_OCCLUDED"]` or just `["FACE_OCCLUDED"]`. You can request for all facial attributes by using `["ALL"]`. Requesting more attributes may increase response time.
         *
         * If you provide both, `["ALL", "DEFAULT"]`, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes).
         */
        public var detectionAttributes: List<Attribute>? = null
        /**
         * The ID you want to assign to all the faces detected in the image.
         */
        public var externalImageId: kotlin.String? = null
        /**
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * The maximum number of faces to index. The value of `MaxFaces` must be greater than or equal to 1. `IndexFaces` returns no more than 100 detected faces in an image, even if you specify a larger value for `MaxFaces`.
         *
         * If `IndexFaces` detects more faces than the value of `MaxFaces`, the faces with the lowest quality are filtered out first. If there are still more faces than the value of `MaxFaces`, the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of `MaxFaces`). Information about the unindexed faces is available in the `UnindexedFaces` array.
         *
         * The faces that are returned by `IndexFaces` are sorted by the largest face bounding box size to the smallest size, in descending order.
         *
         * `MaxFaces` can be used with a collection associated with any version of the face model.
         */
        public var maxFaces: kotlin.Int? = null
        /**
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't indexed. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The default value is `AUTO`. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed.
         *
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
         */
        public var qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.IndexFacesRequest) : this() {
            this.collectionId = x.collectionId
            this.detectionAttributes = x.detectionAttributes
            this.externalImageId = x.externalImageId
            this.image = x.image
            this.maxFaces = x.maxFaces
            this.qualityFilter = x.qualityFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.IndexFacesRequest = IndexFacesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
