// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetFaceLivenessSessionResultsResponse private constructor(builder: Builder) {
    /**
     * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output configuration. If no Amazon S3 bucket is defined, raw bytes are sent instead.
     */
    public val auditImages: List<AuditImage>? = builder.auditImages
    /**
     * Probabalistic confidence score for if the person in the given video was live, represented as a float value between 0 to 100.
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * A high-quality image from the Face Liveness video that can be used for face comparison or search. It includes a bounding box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output configuration. In case the reference image is not returned, it's recommended to retry the Liveness check.
     */
    public val referenceImage: aws.sdk.kotlin.services.rekognition.model.AuditImage? = builder.referenceImage
    /**
     * The sessionId for which this request was called.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
     */
    public val status: aws.sdk.kotlin.services.rekognition.model.LivenessSessionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.GetFaceLivenessSessionResultsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetFaceLivenessSessionResultsResponse(")
        append("auditImages=$auditImages,")
        append("confidence=$confidence,")
        append("referenceImage=$referenceImage,")
        append("sessionId=$sessionId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditImages?.hashCode() ?: 0
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (referenceImage?.hashCode() ?: 0)
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetFaceLivenessSessionResultsResponse

        if (auditImages != other.auditImages) return false
        if (confidence != other.confidence) return false
        if (referenceImage != other.referenceImage) return false
        if (sessionId != other.sessionId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.GetFaceLivenessSessionResultsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output configuration. If no Amazon S3 bucket is defined, raw bytes are sent instead.
         */
        public var auditImages: List<AuditImage>? = null
        /**
         * Probabalistic confidence score for if the person in the given video was live, represented as a float value between 0 to 100.
         */
        public var confidence: kotlin.Float? = null
        /**
         * A high-quality image from the Face Liveness video that can be used for face comparison or search. It includes a bounding box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output configuration. In case the reference image is not returned, it's recommended to retry the Liveness check.
         */
        public var referenceImage: aws.sdk.kotlin.services.rekognition.model.AuditImage? = null
        /**
         * The sessionId for which this request was called.
         */
        public var sessionId: kotlin.String? = null
        /**
         * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
         */
        public var status: aws.sdk.kotlin.services.rekognition.model.LivenessSessionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.GetFaceLivenessSessionResultsResponse) : this() {
            this.auditImages = x.auditImages
            this.confidence = x.confidence
            this.referenceImage = x.referenceImage
            this.sessionId = x.sessionId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.GetFaceLivenessSessionResultsResponse = GetFaceLivenessSessionResultsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.AuditImage] inside the given [block]
         */
        public fun referenceImage(block: aws.sdk.kotlin.services.rekognition.model.AuditImage.Builder.() -> kotlin.Unit) {
            this.referenceImage = aws.sdk.kotlin.services.rekognition.model.AuditImage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sessionId == null) sessionId = ""
            if (status == null) status = LivenessSessionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
