// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The predicted gender of a detected face.
 *
 * Amazon Rekognition makes gender binary (male/female) predictions based on the physical appearance of a face in a particular image. This kind of prediction is not designed to categorize a person’s gender identity, and you shouldn't use Amazon Rekognition to make such a determination. For example, a male actor wearing a long-haired wig and earrings for a role might be predicted as female.
 *
 * Using Amazon Rekognition to make gender binary predictions is best suited for use cases where aggregate gender distribution statistics need to be analyzed without identifying specific users. For example, the percentage of female users compared to male users on a social media platform.
 *
 * We don't recommend using gender binary predictions to make decisions that impact an individual's rights, privacy, or access to services.
 */
public class Gender private constructor(builder: Builder) {
    /**
     * Level of confidence in the prediction.
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * The predicted gender of the face.
     */
    public val value: aws.sdk.kotlin.services.rekognition.model.GenderType? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.Gender = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Gender(")
        append("confidence=$confidence,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Gender

        if (confidence != other.confidence) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.Gender = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Level of confidence in the prediction.
         */
        public var confidence: kotlin.Float? = null
        /**
         * The predicted gender of the face.
         */
        public var value: aws.sdk.kotlin.services.rekognition.model.GenderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.Gender) : this() {
            this.confidence = x.confidence
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.Gender = Gender(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
