// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input face recognition parameters for an Amazon Rekognition stream processor. Includes the collection to use for face recognition and the face attributes to detect. Defining the settings is required in the request parameter for CreateStreamProcessor.
 */
public class FaceSearchSettings private constructor(builder: Builder) {
    /**
     * The ID of a collection that contains faces that you want to search for.
     */
    public val collectionId: kotlin.String? = builder.collectionId
    /**
     * Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.
     */
    public val faceMatchThreshold: kotlin.Float? = builder.faceMatchThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FaceSearchSettings(")
        append("collectionId=$collectionId,")
        append("faceMatchThreshold=$faceMatchThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionId?.hashCode() ?: 0
        result = 31 * result + (faceMatchThreshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FaceSearchSettings

        if (collectionId != other.collectionId) return false
        if (faceMatchThreshold != other.faceMatchThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of a collection that contains faces that you want to search for.
         */
        public var collectionId: kotlin.String? = null
        /**
         * Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.
         */
        public var faceMatchThreshold: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings) : this() {
            this.collectionId = x.collectionId
            this.faceMatchThreshold = x.faceMatchThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings = FaceSearchSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
