// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Structure containing attributes of the face that the algorithm detected.
 *
 * A `FaceDetail` object contains either the default facial attributes or all facial attributes. The default attributes are `BoundingBox`, `Confidence`, `Landmarks`, `Pose`, and `Quality`.
 *
 * GetFaceDetection is the only Amazon Rekognition Video stored video operation that can return a `FaceDetail` object with all attributes. To specify which attributes to return, use the `FaceAttributes` input parameter for StartFaceDetection. The following Amazon Rekognition Video operations return only the default attributes. The corresponding Start operations don't have a `FaceAttributes` input parameter:
 * + GetCelebrityRecognition
 * + GetPersonTracking
 * + GetFaceSearch
 *
 * The Amazon Rekognition Image DetectFaces and IndexFaces operations can return all facial attributes. To specify which attributes to return, use the `Attributes` input parameter for `DetectFaces`. For `IndexFaces`, use the `DetectAttributes` input parameter.
 */
public class FaceDetail private constructor(builder: Builder) {
    /**
     * The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.
     */
    public val ageRange: aws.sdk.kotlin.services.rekognition.model.AgeRange? = builder.ageRange
    /**
     * Indicates whether or not the face has a beard, and the confidence level in the determination.
     */
    public val beard: aws.sdk.kotlin.services.rekognition.model.Beard? = builder.beard
    /**
     * Bounding box of the face. Default attribute.
     */
    public val boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = builder.boundingBox
    /**
     * Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.
     */
    public val emotions: List<Emotion>? = builder.emotions
    /**
     * Indicates the direction the eyes are gazing in, as defined by pitch and yaw.
     */
    public val eyeDirection: aws.sdk.kotlin.services.rekognition.model.EyeDirection? = builder.eyeDirection
    /**
     * Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.
     */
    public val eyeglasses: aws.sdk.kotlin.services.rekognition.model.Eyeglasses? = builder.eyeglasses
    /**
     * Indicates whether or not the eyes on the face are open, and the confidence level in the determination.
     */
    public val eyesOpen: aws.sdk.kotlin.services.rekognition.model.EyeOpen? = builder.eyesOpen
    /**
     * `FaceOccluded` should return "true" with a high confidence score if a detected face’s eyes, nose, and mouth are partially captured or if they are covered by masks, dark sunglasses, cell phones, hands, or other objects. `FaceOccluded` should return "false" with a high confidence score if common occurrences that do not impact face verification are detected, such as eye glasses, lightly tinted sunglasses, strands of hair, and others.
     */
    public val faceOccluded: aws.sdk.kotlin.services.rekognition.model.FaceOccluded? = builder.faceOccluded
    /**
     * The predicted gender of a detected face.
     */
    public val gender: aws.sdk.kotlin.services.rekognition.model.Gender? = builder.gender
    /**
     * Indicates the location of landmarks on the face. Default attribute.
     */
    public val landmarks: List<Landmark>? = builder.landmarks
    /**
     * Indicates whether or not the mouth on the face is open, and the confidence level in the determination.
     */
    public val mouthOpen: aws.sdk.kotlin.services.rekognition.model.MouthOpen? = builder.mouthOpen
    /**
     * Indicates whether or not the face has a mustache, and the confidence level in the determination.
     */
    public val mustache: aws.sdk.kotlin.services.rekognition.model.Mustache? = builder.mustache
    /**
     * Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.
     */
    public val pose: aws.sdk.kotlin.services.rekognition.model.Pose? = builder.pose
    /**
     * Identifies image brightness and sharpness. Default attribute.
     */
    public val quality: aws.sdk.kotlin.services.rekognition.model.ImageQuality? = builder.quality
    /**
     * Indicates whether or not the face is smiling, and the confidence level in the determination.
     */
    public val smile: aws.sdk.kotlin.services.rekognition.model.Smile? = builder.smile
    /**
     * Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.
     */
    public val sunglasses: aws.sdk.kotlin.services.rekognition.model.Sunglasses? = builder.sunglasses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.FaceDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FaceDetail(")
        append("ageRange=$ageRange,")
        append("beard=$beard,")
        append("boundingBox=$boundingBox,")
        append("confidence=$confidence,")
        append("emotions=$emotions,")
        append("eyeDirection=$eyeDirection,")
        append("eyeglasses=$eyeglasses,")
        append("eyesOpen=$eyesOpen,")
        append("faceOccluded=$faceOccluded,")
        append("gender=$gender,")
        append("landmarks=$landmarks,")
        append("mouthOpen=$mouthOpen,")
        append("mustache=$mustache,")
        append("pose=$pose,")
        append("quality=$quality,")
        append("smile=$smile,")
        append("sunglasses=$sunglasses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ageRange?.hashCode() ?: 0
        result = 31 * result + (beard?.hashCode() ?: 0)
        result = 31 * result + (boundingBox?.hashCode() ?: 0)
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (emotions?.hashCode() ?: 0)
        result = 31 * result + (eyeDirection?.hashCode() ?: 0)
        result = 31 * result + (eyeglasses?.hashCode() ?: 0)
        result = 31 * result + (eyesOpen?.hashCode() ?: 0)
        result = 31 * result + (faceOccluded?.hashCode() ?: 0)
        result = 31 * result + (gender?.hashCode() ?: 0)
        result = 31 * result + (landmarks?.hashCode() ?: 0)
        result = 31 * result + (mouthOpen?.hashCode() ?: 0)
        result = 31 * result + (mustache?.hashCode() ?: 0)
        result = 31 * result + (pose?.hashCode() ?: 0)
        result = 31 * result + (quality?.hashCode() ?: 0)
        result = 31 * result + (smile?.hashCode() ?: 0)
        result = 31 * result + (sunglasses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FaceDetail

        if (ageRange != other.ageRange) return false
        if (beard != other.beard) return false
        if (boundingBox != other.boundingBox) return false
        if (confidence != other.confidence) return false
        if (emotions != other.emotions) return false
        if (eyeDirection != other.eyeDirection) return false
        if (eyeglasses != other.eyeglasses) return false
        if (eyesOpen != other.eyesOpen) return false
        if (faceOccluded != other.faceOccluded) return false
        if (gender != other.gender) return false
        if (landmarks != other.landmarks) return false
        if (mouthOpen != other.mouthOpen) return false
        if (mustache != other.mustache) return false
        if (pose != other.pose) return false
        if (quality != other.quality) return false
        if (smile != other.smile) return false
        if (sunglasses != other.sunglasses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.FaceDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.
         */
        public var ageRange: aws.sdk.kotlin.services.rekognition.model.AgeRange? = null
        /**
         * Indicates whether or not the face has a beard, and the confidence level in the determination.
         */
        public var beard: aws.sdk.kotlin.services.rekognition.model.Beard? = null
        /**
         * Bounding box of the face. Default attribute.
         */
        public var boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = null
        /**
         * Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.
         */
        public var confidence: kotlin.Float? = null
        /**
         * The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.
         */
        public var emotions: List<Emotion>? = null
        /**
         * Indicates the direction the eyes are gazing in, as defined by pitch and yaw.
         */
        public var eyeDirection: aws.sdk.kotlin.services.rekognition.model.EyeDirection? = null
        /**
         * Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.
         */
        public var eyeglasses: aws.sdk.kotlin.services.rekognition.model.Eyeglasses? = null
        /**
         * Indicates whether or not the eyes on the face are open, and the confidence level in the determination.
         */
        public var eyesOpen: aws.sdk.kotlin.services.rekognition.model.EyeOpen? = null
        /**
         * `FaceOccluded` should return "true" with a high confidence score if a detected face’s eyes, nose, and mouth are partially captured or if they are covered by masks, dark sunglasses, cell phones, hands, or other objects. `FaceOccluded` should return "false" with a high confidence score if common occurrences that do not impact face verification are detected, such as eye glasses, lightly tinted sunglasses, strands of hair, and others.
         */
        public var faceOccluded: aws.sdk.kotlin.services.rekognition.model.FaceOccluded? = null
        /**
         * The predicted gender of a detected face.
         */
        public var gender: aws.sdk.kotlin.services.rekognition.model.Gender? = null
        /**
         * Indicates the location of landmarks on the face. Default attribute.
         */
        public var landmarks: List<Landmark>? = null
        /**
         * Indicates whether or not the mouth on the face is open, and the confidence level in the determination.
         */
        public var mouthOpen: aws.sdk.kotlin.services.rekognition.model.MouthOpen? = null
        /**
         * Indicates whether or not the face has a mustache, and the confidence level in the determination.
         */
        public var mustache: aws.sdk.kotlin.services.rekognition.model.Mustache? = null
        /**
         * Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.
         */
        public var pose: aws.sdk.kotlin.services.rekognition.model.Pose? = null
        /**
         * Identifies image brightness and sharpness. Default attribute.
         */
        public var quality: aws.sdk.kotlin.services.rekognition.model.ImageQuality? = null
        /**
         * Indicates whether or not the face is smiling, and the confidence level in the determination.
         */
        public var smile: aws.sdk.kotlin.services.rekognition.model.Smile? = null
        /**
         * Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.
         */
        public var sunglasses: aws.sdk.kotlin.services.rekognition.model.Sunglasses? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.FaceDetail) : this() {
            this.ageRange = x.ageRange
            this.beard = x.beard
            this.boundingBox = x.boundingBox
            this.confidence = x.confidence
            this.emotions = x.emotions
            this.eyeDirection = x.eyeDirection
            this.eyeglasses = x.eyeglasses
            this.eyesOpen = x.eyesOpen
            this.faceOccluded = x.faceOccluded
            this.gender = x.gender
            this.landmarks = x.landmarks
            this.mouthOpen = x.mouthOpen
            this.mustache = x.mustache
            this.pose = x.pose
            this.quality = x.quality
            this.smile = x.smile
            this.sunglasses = x.sunglasses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.FaceDetail = FaceDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.AgeRange] inside the given [block]
         */
        public fun ageRange(block: aws.sdk.kotlin.services.rekognition.model.AgeRange.Builder.() -> kotlin.Unit) {
            this.ageRange = aws.sdk.kotlin.services.rekognition.model.AgeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Beard] inside the given [block]
         */
        public fun beard(block: aws.sdk.kotlin.services.rekognition.model.Beard.Builder.() -> kotlin.Unit) {
            this.beard = aws.sdk.kotlin.services.rekognition.model.Beard.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.BoundingBox] inside the given [block]
         */
        public fun boundingBox(block: aws.sdk.kotlin.services.rekognition.model.BoundingBox.Builder.() -> kotlin.Unit) {
            this.boundingBox = aws.sdk.kotlin.services.rekognition.model.BoundingBox.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.EyeDirection] inside the given [block]
         */
        public fun eyeDirection(block: aws.sdk.kotlin.services.rekognition.model.EyeDirection.Builder.() -> kotlin.Unit) {
            this.eyeDirection = aws.sdk.kotlin.services.rekognition.model.EyeDirection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Eyeglasses] inside the given [block]
         */
        public fun eyeglasses(block: aws.sdk.kotlin.services.rekognition.model.Eyeglasses.Builder.() -> kotlin.Unit) {
            this.eyeglasses = aws.sdk.kotlin.services.rekognition.model.Eyeglasses.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.EyeOpen] inside the given [block]
         */
        public fun eyesOpen(block: aws.sdk.kotlin.services.rekognition.model.EyeOpen.Builder.() -> kotlin.Unit) {
            this.eyesOpen = aws.sdk.kotlin.services.rekognition.model.EyeOpen.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.FaceOccluded] inside the given [block]
         */
        public fun faceOccluded(block: aws.sdk.kotlin.services.rekognition.model.FaceOccluded.Builder.() -> kotlin.Unit) {
            this.faceOccluded = aws.sdk.kotlin.services.rekognition.model.FaceOccluded.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Gender] inside the given [block]
         */
        public fun gender(block: aws.sdk.kotlin.services.rekognition.model.Gender.Builder.() -> kotlin.Unit) {
            this.gender = aws.sdk.kotlin.services.rekognition.model.Gender.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MouthOpen] inside the given [block]
         */
        public fun mouthOpen(block: aws.sdk.kotlin.services.rekognition.model.MouthOpen.Builder.() -> kotlin.Unit) {
            this.mouthOpen = aws.sdk.kotlin.services.rekognition.model.MouthOpen.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Mustache] inside the given [block]
         */
        public fun mustache(block: aws.sdk.kotlin.services.rekognition.model.Mustache.Builder.() -> kotlin.Unit) {
            this.mustache = aws.sdk.kotlin.services.rekognition.model.Mustache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Pose] inside the given [block]
         */
        public fun pose(block: aws.sdk.kotlin.services.rekognition.model.Pose.Builder.() -> kotlin.Unit) {
            this.pose = aws.sdk.kotlin.services.rekognition.model.Pose.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ImageQuality] inside the given [block]
         */
        public fun quality(block: aws.sdk.kotlin.services.rekognition.model.ImageQuality.Builder.() -> kotlin.Unit) {
            this.quality = aws.sdk.kotlin.services.rekognition.model.ImageQuality.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Smile] inside the given [block]
         */
        public fun smile(block: aws.sdk.kotlin.services.rekognition.model.Smile.Builder.() -> kotlin.Unit) {
            this.smile = aws.sdk.kotlin.services.rekognition.model.Smile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Sunglasses] inside the given [block]
         */
        public fun sunglasses(block: aws.sdk.kotlin.services.rekognition.model.Sunglasses.Builder.() -> kotlin.Unit) {
            this.sunglasses = aws.sdk.kotlin.services.rekognition.model.Sunglasses.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
