// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned.
 */
public class Face private constructor(builder: Builder) {
    /**
     * Bounding box of the face.
     */
    public val boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = builder.boundingBox
    /**
     * Confidence level that the bounding box contains a face (and not a different object such as a tree).
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * Identifier that you assign to all the faces in the input image.
     */
    public val externalImageId: kotlin.String? = builder.externalImageId
    /**
     * Unique identifier that Amazon Rekognition assigns to the face.
     */
    public val faceId: kotlin.String? = builder.faceId
    /**
     * Unique identifier that Amazon Rekognition assigns to the input image.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The version of the face detect and storage model that was used when indexing the face vector.
     */
    public val indexFacesModelVersion: kotlin.String? = builder.indexFacesModelVersion
    /**
     * Unique identifier assigned to the user.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.Face = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Face(")
        append("boundingBox=$boundingBox,")
        append("confidence=$confidence,")
        append("externalImageId=$externalImageId,")
        append("faceId=$faceId,")
        append("imageId=$imageId,")
        append("indexFacesModelVersion=$indexFacesModelVersion,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boundingBox?.hashCode() ?: 0
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (externalImageId?.hashCode() ?: 0)
        result = 31 * result + (faceId?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (indexFacesModelVersion?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Face

        if (boundingBox != other.boundingBox) return false
        if (confidence != other.confidence) return false
        if (externalImageId != other.externalImageId) return false
        if (faceId != other.faceId) return false
        if (imageId != other.imageId) return false
        if (indexFacesModelVersion != other.indexFacesModelVersion) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.Face = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Bounding box of the face.
         */
        public var boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = null
        /**
         * Confidence level that the bounding box contains a face (and not a different object such as a tree).
         */
        public var confidence: kotlin.Float? = null
        /**
         * Identifier that you assign to all the faces in the input image.
         */
        public var externalImageId: kotlin.String? = null
        /**
         * Unique identifier that Amazon Rekognition assigns to the face.
         */
        public var faceId: kotlin.String? = null
        /**
         * Unique identifier that Amazon Rekognition assigns to the input image.
         */
        public var imageId: kotlin.String? = null
        /**
         * The version of the face detect and storage model that was used when indexing the face vector.
         */
        public var indexFacesModelVersion: kotlin.String? = null
        /**
         * Unique identifier assigned to the user.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.Face) : this() {
            this.boundingBox = x.boundingBox
            this.confidence = x.confidence
            this.externalImageId = x.externalImageId
            this.faceId = x.faceId
            this.imageId = x.imageId
            this.indexFacesModelVersion = x.indexFacesModelVersion
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.Face = Face(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.BoundingBox] inside the given [block]
         */
        public fun boundingBox(block: aws.sdk.kotlin.services.rekognition.model.BoundingBox.Builder.() -> kotlin.Unit) {
            this.boundingBox = aws.sdk.kotlin.services.rekognition.model.BoundingBox.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
