// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DetectLabelsRequest private constructor(builder: Builder) {
    /**
     * A list of the types of analysis to perform. Specifying GENERAL_LABELS uses the label detection feature, while specifying IMAGE_PROPERTIES returns information regarding image color and quality. If no option is specified GENERAL_LABELS is used by default.
     */
    public val features: List<DetectLabelsFeatureName>? = builder.features
    /**
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image
    /**
     * Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. Only valid when GENERAL_LABELS is specified as a feature type in the Feature input parameter.
     */
    public val maxLabels: kotlin.Int? = builder.maxLabels
    /**
     * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with confidence lower than this specified value.
     *
     * If `MinConfidence` is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent. Only valid when GENERAL_LABELS is specified as a feature type in the Feature input parameter.
     */
    public val minConfidence: kotlin.Float? = builder.minConfidence
    /**
     * A list of the filters to be applied to returned detected labels and image properties. Specified filters can be inclusive, exclusive, or a combination of both. Filters can be used for individual labels or label categories. The exact label names or label categories must be supplied. For a full list of labels and label categories, see [Detecting labels](https://docs.aws.amazon.com/rekognition/latest/dg/labels.html).
     */
    public val settings: aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DetectLabelsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectLabelsRequest(")
        append("features=$features,")
        append("image=$image,")
        append("maxLabels=$maxLabels,")
        append("minConfidence=$minConfidence,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = features?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (maxLabels ?: 0)
        result = 31 * result + (minConfidence?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectLabelsRequest

        if (features != other.features) return false
        if (image != other.image) return false
        if (maxLabels != other.maxLabels) return false
        if (minConfidence != other.minConfidence) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DetectLabelsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of the types of analysis to perform. Specifying GENERAL_LABELS uses the label detection feature, while specifying IMAGE_PROPERTIES returns information regarding image color and quality. If no option is specified GENERAL_LABELS is used by default.
         */
        public var features: List<DetectLabelsFeatureName>? = null
        /**
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. Only valid when GENERAL_LABELS is specified as a feature type in the Feature input parameter.
         */
        public var maxLabels: kotlin.Int? = null
        /**
         * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with confidence lower than this specified value.
         *
         * If `MinConfidence` is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent. Only valid when GENERAL_LABELS is specified as a feature type in the Feature input parameter.
         */
        public var minConfidence: kotlin.Float? = null
        /**
         * A list of the filters to be applied to returned detected labels and image properties. Specified filters can be inclusive, exclusive, or a combination of both. Filters can be used for individual labels or label categories. The exact label names or label categories must be supplied. For a full list of labels and label categories, see [Detecting labels](https://docs.aws.amazon.com/rekognition/latest/dg/labels.html).
         */
        public var settings: aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DetectLabelsRequest) : this() {
            this.features = x.features
            this.image = x.image
            this.maxLabels = x.maxLabels
            this.minConfidence = x.minConfidence
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DetectLabelsRequest = DetectLabelsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
