// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the quality and dominant colors of an input image. Quality and color information is returned for the entire image, foreground, and background.
 */
public class DetectLabelsImageProperties private constructor(builder: Builder) {
    /**
     * Information about the properties of an image’s background, including the background’s quality and dominant colors, including the quality and dominant colors of the image.
     */
    public val background: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageBackground? = builder.background
    /**
     * Information about the dominant colors found in an image, described with RGB values, CSS color name, simplified color name, and PixelPercentage (the percentage of image pixels that have a particular color).
     */
    public val dominantColors: List<DominantColor>? = builder.dominantColors
    /**
     * Information about the properties of an image’s foreground, including the foreground’s quality and dominant colors, including the quality and dominant colors of the image.
     */
    public val foreground: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageForeground? = builder.foreground
    /**
     * Information about the quality of the image foreground as defined by brightness, sharpness, and contrast. The higher the value the greater the brightness, sharpness, and contrast respectively.
     */
    public val quality: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageQuality? = builder.quality

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectLabelsImageProperties(")
        append("background=$background,")
        append("dominantColors=$dominantColors,")
        append("foreground=$foreground,")
        append("quality=$quality")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = background?.hashCode() ?: 0
        result = 31 * result + (dominantColors?.hashCode() ?: 0)
        result = 31 * result + (foreground?.hashCode() ?: 0)
        result = 31 * result + (quality?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectLabelsImageProperties

        if (background != other.background) return false
        if (dominantColors != other.dominantColors) return false
        if (foreground != other.foreground) return false
        if (quality != other.quality) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the properties of an image’s background, including the background’s quality and dominant colors, including the quality and dominant colors of the image.
         */
        public var background: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageBackground? = null
        /**
         * Information about the dominant colors found in an image, described with RGB values, CSS color name, simplified color name, and PixelPercentage (the percentage of image pixels that have a particular color).
         */
        public var dominantColors: List<DominantColor>? = null
        /**
         * Information about the properties of an image’s foreground, including the foreground’s quality and dominant colors, including the quality and dominant colors of the image.
         */
        public var foreground: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageForeground? = null
        /**
         * Information about the quality of the image foreground as defined by brightness, sharpness, and contrast. The higher the value the greater the brightness, sharpness, and contrast respectively.
         */
        public var quality: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageQuality? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageProperties) : this() {
            this.background = x.background
            this.dominantColors = x.dominantColors
            this.foreground = x.foreground
            this.quality = x.quality
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageProperties = DetectLabelsImageProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageBackground] inside the given [block]
         */
        public fun background(block: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageBackground.Builder.() -> kotlin.Unit) {
            this.background = aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageBackground.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageForeground] inside the given [block]
         */
        public fun foreground(block: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageForeground.Builder.() -> kotlin.Unit) {
            this.foreground = aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageForeground.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageQuality] inside the given [block]
         */
        public fun quality(block: aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageQuality.Builder.() -> kotlin.Unit) {
            this.quality = aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageQuality.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
