// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DetectFacesRequest private constructor(builder: Builder) {
    /**
     * An array of facial attributes you want to be returned. A `DEFAULT` subset of facial attributes - `BoundingBox`, `Confidence`, `Pose`, `Quality`, and `Landmarks` - will always be returned. You can request for specific facial attributes (in addition to the default list) - by using &#91;`"DEFAULT", "FACE_OCCLUDED"`&#93; or just &#91;`"FACE_OCCLUDED"`&#93;. You can request for all facial attributes by using &#91;`"ALL"]`. Requesting more attributes may increase response time.
     *
     * If you provide both, `["ALL", "DEFAULT"]`, the service uses a logical "AND" operator to determine which attributes to return (in this case, all attributes).
     *
     * Note that while the FaceOccluded and EyeDirection attributes are supported when using `DetectFaces`, they aren't supported when analyzing videos with `StartFaceDetection` and `GetFaceDetection`.
     */
    public val attributes: List<Attribute>? = builder.attributes
    /**
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DetectFacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectFacesRequest(")
        append("attributes=$attributes,")
        append("image=$image")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectFacesRequest

        if (attributes != other.attributes) return false
        if (image != other.image) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DetectFacesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of facial attributes you want to be returned. A `DEFAULT` subset of facial attributes - `BoundingBox`, `Confidence`, `Pose`, `Quality`, and `Landmarks` - will always be returned. You can request for specific facial attributes (in addition to the default list) - by using &#91;`"DEFAULT", "FACE_OCCLUDED"`&#93; or just &#91;`"FACE_OCCLUDED"`&#93;. You can request for all facial attributes by using &#91;`"ALL"]`. Requesting more attributes may increase response time.
         *
         * If you provide both, `["ALL", "DEFAULT"]`, the service uses a logical "AND" operator to determine which attributes to return (in this case, all attributes).
         *
         * Note that while the FaceOccluded and EyeDirection attributes are supported when using `DetectFaces`, they aren't supported when analyzing videos with `StartFaceDetection` and `GetFaceDetection`.
         */
        public var attributes: List<Attribute>? = null
        /**
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DetectFacesRequest) : this() {
            this.attributes = x.attributes
            this.image = x.image
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DetectFacesRequest = DetectFacesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
