// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The source that Amazon Rekognition Custom Labels uses to create a dataset. To use an Amazon Sagemaker format manifest file, specify the S3 bucket location in the `GroundTruthManifest` field. The S3 bucket must be in your AWS account. To create a copy of an existing dataset, specify the Amazon Resource Name (ARN) of an existing dataset in `DatasetArn`.
 *
 * You need to specify a value for `DatasetArn` or `GroundTruthManifest`, but not both. if you supply both values, or if you don't specify any values, an InvalidParameterException exception occurs.
 *
 * For more information, see CreateDataset.
 */
public class DatasetSource private constructor(builder: Builder) {
    /**
     * The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file.
     */
    public val groundTruthManifest: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest? = builder.groundTruthManifest

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DatasetSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetSource(")
        append("datasetArn=$datasetArn,")
        append("groundTruthManifest=$groundTruthManifest")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetArn?.hashCode() ?: 0
        result = 31 * result + (groundTruthManifest?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetSource

        if (datasetArn != other.datasetArn) return false
        if (groundTruthManifest != other.groundTruthManifest) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DatasetSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file.
         */
        public var groundTruthManifest: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DatasetSource) : this() {
            this.datasetArn = x.datasetArn
            this.groundTruthManifest = x.groundTruthManifest
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DatasetSource = DatasetSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest] inside the given [block]
         */
        public fun groundTruthManifest(block: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest.Builder.() -> kotlin.Unit) {
            this.groundTruthManifest = aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
