// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for an Amazon Rekognition Custom Labels dataset. For more information, see ProjectDescription.
 */
public class DatasetMetadata private constructor(builder: Builder) {
    /**
     * The Unix timestamp for the date and time that the dataset was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The Amazon Resource Name (ARN) for the dataset.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The type of the dataset.
     */
    public val datasetType: aws.sdk.kotlin.services.rekognition.model.DatasetType? = builder.datasetType
    /**
     * The status for the dataset.
     */
    public val status: aws.sdk.kotlin.services.rekognition.model.DatasetStatus? = builder.status
    /**
     * The status message for the dataset.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed.
     */
    public val statusMessageCode: aws.sdk.kotlin.services.rekognition.model.DatasetStatusMessageCode? = builder.statusMessageCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DatasetMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetMetadata(")
        append("creationTimestamp=$creationTimestamp,")
        append("datasetArn=$datasetArn,")
        append("datasetType=$datasetType,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("statusMessageCode=$statusMessageCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (statusMessageCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetMetadata

        if (creationTimestamp != other.creationTimestamp) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetType != other.datasetType) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (statusMessageCode != other.statusMessageCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DatasetMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix timestamp for the date and time that the dataset was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the dataset.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The type of the dataset.
         */
        public var datasetType: aws.sdk.kotlin.services.rekognition.model.DatasetType? = null
        /**
         * The status for the dataset.
         */
        public var status: aws.sdk.kotlin.services.rekognition.model.DatasetStatus? = null
        /**
         * The status message for the dataset.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed.
         */
        public var statusMessageCode: aws.sdk.kotlin.services.rekognition.model.DatasetStatusMessageCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DatasetMetadata) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.datasetArn = x.datasetArn
            this.datasetType = x.datasetType
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.statusMessageCode = x.statusMessageCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DatasetMetadata = DatasetMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
