// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes updates or additions to a dataset. A Single update or addition is an entry (JSON Line) that provides information about a single image. To update an existing entry, you match the `source-ref` field of the update entry with the `source-ref` filed of the entry that you want to update. If the `source-ref` field doesn't match an existing entry, the entry is added to dataset as a new entry.
 */
public class DatasetChanges private constructor(builder: Builder) {
    /**
     * A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling UpdateDatasetEntries. If you are using an AWS SDK to call `UpdateDatasetEntries`, you don't need to encode `Changes` as the SDK encodes the data for you.
     *
     * For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the *Amazon Rekognition Custom Labels Developer Guide*.
     */
    public val groundTruth: kotlin.ByteArray = requireNotNull(builder.groundTruth) { "A non-null value must be provided for groundTruth" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DatasetChanges = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetChanges(")
        append("groundTruth=$groundTruth")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groundTruth.contentHashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetChanges

        if (groundTruth != null) {
            if (other.groundTruth == null) return false
            if (!groundTruth.contentEquals(other.groundTruth)) return false
        } else if (other.groundTruth != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DatasetChanges = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling UpdateDatasetEntries. If you are using an AWS SDK to call `UpdateDatasetEntries`, you don't need to encode `Changes` as the SDK encodes the data for you.
         *
         * For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the *Amazon Rekognition Custom Labels Developer Guide*.
         */
        public var groundTruth: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DatasetChanges) : this() {
            this.groundTruth = x.groundTruth
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DatasetChanges = DatasetChanges(this)

        internal fun correctErrors(): Builder {
            if (groundTruth == null) groundTruth = ByteArray(0)
            return this
        }
    }
}
