// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateStreamProcessorRequest private constructor(builder: Builder) {
    /**
     * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams.
     */
    public val dataSharingPreference: aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference? = builder.dataSharingPreference
    /**
     * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is `StreamProcessorInput`. This is required for both face search and label detection stream processors.
     */
    public val input: aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput? = builder.input
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt results and data published to your Amazon S3 bucket, which includes image frames and hero images. Your source images are unaffected.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An identifier you assign to the stream processor. You can use `Name` to manage the stream processor. For example, you can get the current status of the stream processor by calling DescribeStreamProcessor. `Name` is idempotent. This is required for both face search and label detection stream processors.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     *
     * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.
     *
     * Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.
     */
    public val notificationChannel: aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel? = builder.notificationChannel
    /**
     * Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is `StreamProcessorOutput`. This must be a S3Destination of an Amazon S3 bucket that you own for a label detection stream processor or a Kinesis data stream ARN for a face search stream processor.
     */
    public val output: aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput? = builder.output
    /**
     * Specifies locations in the frames where Amazon Rekognition checks for objects or people. You can specify up to 10 regions of interest, and each region has either a polygon or a bounding box. This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor.
     */
    public val regionsOfInterest: List<RegionOfInterest>? = builder.regionsOfInterest
    /**
     * The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Input parameters used in a streaming video analyzed by a stream processor. You can use `FaceSearch` to recognize faces in a streaming video, or you can use `ConnectedHome` to detect labels.
     */
    public val settings: aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings? = builder.settings
    /**
     * A set of tags (key-value pairs) that you want to attach to the stream processor.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CreateStreamProcessorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStreamProcessorRequest(")
        append("dataSharingPreference=$dataSharingPreference,")
        append("input=$input,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("notificationChannel=$notificationChannel,")
        append("output=$output,")
        append("regionsOfInterest=$regionsOfInterest,")
        append("roleArn=$roleArn,")
        append("settings=$settings,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSharingPreference?.hashCode() ?: 0
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (regionsOfInterest?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStreamProcessorRequest

        if (dataSharingPreference != other.dataSharingPreference) return false
        if (input != other.input) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (notificationChannel != other.notificationChannel) return false
        if (output != other.output) return false
        if (regionsOfInterest != other.regionsOfInterest) return false
        if (roleArn != other.roleArn) return false
        if (settings != other.settings) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CreateStreamProcessorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams.
         */
        public var dataSharingPreference: aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference? = null
        /**
         * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is `StreamProcessorInput`. This is required for both face search and label detection stream processors.
         */
        public var input: aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt results and data published to your Amazon S3 bucket, which includes image frames and hero images. Your source images are unaffected.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * An identifier you assign to the stream processor. You can use `Name` to manage the stream processor. For example, you can get the current status of the stream processor by calling DescribeStreamProcessor. `Name` is idempotent. This is required for both face search and label detection stream processors.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
         *
         * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.
         *
         * Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.
         */
        public var notificationChannel: aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel? = null
        /**
         * Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is `StreamProcessorOutput`. This must be a S3Destination of an Amazon S3 bucket that you own for a label detection stream processor or a Kinesis data stream ARN for a face search stream processor.
         */
        public var output: aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput? = null
        /**
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. You can specify up to 10 regions of interest, and each region has either a polygon or a bounding box. This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor.
         */
        public var regionsOfInterest: List<RegionOfInterest>? = null
        /**
         * The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Input parameters used in a streaming video analyzed by a stream processor. You can use `FaceSearch` to recognize faces in a streaming video, or you can use `ConnectedHome` to detect labels.
         */
        public var settings: aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings? = null
        /**
         * A set of tags (key-value pairs) that you want to attach to the stream processor.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CreateStreamProcessorRequest) : this() {
            this.dataSharingPreference = x.dataSharingPreference
            this.input = x.input
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.notificationChannel = x.notificationChannel
            this.output = x.output
            this.regionsOfInterest = x.regionsOfInterest
            this.roleArn = x.roleArn
            this.settings = x.settings
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CreateStreamProcessorRequest = CreateStreamProcessorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference] inside the given [block]
         */
        public fun dataSharingPreference(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference.Builder.() -> kotlin.Unit) {
            this.dataSharingPreference = aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput] inside the given [block]
         */
        public fun output(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput.Builder.() -> kotlin.Unit) {
            this.output = aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
