// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateProjectVersionRequest private constructor(builder: Builder) {
    /**
     * Feature-specific configuration of the training job. If the job configuration does not match the feature type associated with the project, an InvalidParameterException is returned.
     */
    public val featureConfig: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig? = builder.featureConfig
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training images, test images, and manifest files copied into the service for the project version. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (`OutputConfig`).
     *
     * If you choose to use your own KMS key, you need the following permissions on the KMS key.
     * + kms:CreateGrant
     * + kms:DescribeKey
     * + kms:GenerateDataKey
     * + kms:Decrypt
     *
     * If you don't specify a value for `KmsKeyId`, images copied into the service are encrypted using a key that AWS owns and manages.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon S3 bucket location to store the results of training. The bucket can be any S3 bucket in your AWS account. You need `s3:PutObject` permission on the bucket.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = builder.outputConfig
    /**
     * The ARN of the Amazon Rekognition project that will manage the project version you want to train.
     */
    public val projectArn: kotlin.String? = builder.projectArn
    /**
     * A set of tags (key-value pairs) that you want to attach to the project version.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies an external manifest that the service uses to test the project version. If you specify `TestingData` you must also specify `TrainingData`. The project must not have any associated datasets.
     */
    public val testingData: aws.sdk.kotlin.services.rekognition.model.TestingData? = builder.testingData
    /**
     * Specifies an external manifest that the services uses to train the project version. If you specify `TrainingData` you must also specify `TestingData`. The project must not have any associated datasets.
     */
    public val trainingData: aws.sdk.kotlin.services.rekognition.model.TrainingData? = builder.trainingData
    /**
     * A description applied to the project version being created.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription
    /**
     * A name for the version of the project version. This value must be unique.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CreateProjectVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectVersionRequest(")
        append("featureConfig=$featureConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputConfig=$outputConfig,")
        append("projectArn=$projectArn,")
        append("tags=$tags,")
        append("testingData=$testingData,")
        append("trainingData=$trainingData,")
        append("versionDescription=$versionDescription,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureConfig?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (testingData?.hashCode() ?: 0)
        result = 31 * result + (trainingData?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProjectVersionRequest

        if (featureConfig != other.featureConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputConfig != other.outputConfig) return false
        if (projectArn != other.projectArn) return false
        if (tags != other.tags) return false
        if (testingData != other.testingData) return false
        if (trainingData != other.trainingData) return false
        if (versionDescription != other.versionDescription) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CreateProjectVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Feature-specific configuration of the training job. If the job configuration does not match the feature type associated with the project, an InvalidParameterException is returned.
         */
        public var featureConfig: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training images, test images, and manifest files copied into the service for the project version. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (`OutputConfig`).
         *
         * If you choose to use your own KMS key, you need the following permissions on the KMS key.
         * + kms:CreateGrant
         * + kms:DescribeKey
         * + kms:GenerateDataKey
         * + kms:Decrypt
         *
         * If you don't specify a value for `KmsKeyId`, images copied into the service are encrypted using a key that AWS owns and manages.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon S3 bucket location to store the results of training. The bucket can be any S3 bucket in your AWS account. You need `s3:PutObject` permission on the bucket.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = null
        /**
         * The ARN of the Amazon Rekognition project that will manage the project version you want to train.
         */
        public var projectArn: kotlin.String? = null
        /**
         * A set of tags (key-value pairs) that you want to attach to the project version.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies an external manifest that the service uses to test the project version. If you specify `TestingData` you must also specify `TrainingData`. The project must not have any associated datasets.
         */
        public var testingData: aws.sdk.kotlin.services.rekognition.model.TestingData? = null
        /**
         * Specifies an external manifest that the services uses to train the project version. If you specify `TrainingData` you must also specify `TestingData`. The project must not have any associated datasets.
         */
        public var trainingData: aws.sdk.kotlin.services.rekognition.model.TrainingData? = null
        /**
         * A description applied to the project version being created.
         */
        public var versionDescription: kotlin.String? = null
        /**
         * A name for the version of the project version. This value must be unique.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CreateProjectVersionRequest) : this() {
            this.featureConfig = x.featureConfig
            this.kmsKeyId = x.kmsKeyId
            this.outputConfig = x.outputConfig
            this.projectArn = x.projectArn
            this.tags = x.tags
            this.testingData = x.testingData
            this.trainingData = x.trainingData
            this.versionDescription = x.versionDescription
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CreateProjectVersionRequest = CreateProjectVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig] inside the given [block]
         */
        public fun featureConfig(block: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig.Builder.() -> kotlin.Unit) {
            this.featureConfig = aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.OutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TestingData] inside the given [block]
         */
        public fun testingData(block: aws.sdk.kotlin.services.rekognition.model.TestingData.Builder.() -> kotlin.Unit) {
            this.testingData = aws.sdk.kotlin.services.rekognition.model.TestingData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TrainingData] inside the given [block]
         */
        public fun trainingData(block: aws.sdk.kotlin.services.rekognition.model.TrainingData.Builder.() -> kotlin.Unit) {
            this.trainingData = aws.sdk.kotlin.services.rekognition.model.TrainingData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
