// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFaceLivenessSessionRequest private constructor(builder: Builder) {
    /**
     * Idempotent token is used to recognize the Face Liveness request. If the same token is used with multiple `CreateFaceLivenessSession` requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and reference images.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * A session settings object. It contains settings for the operation to be performed. For Face Liveness, it accepts `OutputConfig` and `AuditImagesLimit`.
     */
    public val settings: aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFaceLivenessSessionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("kmsKeyId=$kmsKeyId,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFaceLivenessSessionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Idempotent token is used to recognize the Face Liveness request. If the same token is used with multiple `CreateFaceLivenessSession` requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and reference images.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * A session settings object. It contains settings for the operation to be performed. For Face Liveness, it accepts `OutputConfig` and `AuditImagesLimit`.
         */
        public var settings: aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.kmsKeyId = x.kmsKeyId
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequest = CreateFaceLivenessSessionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
