// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about a celebrity recognized by the RecognizeCelebrities operation.
 */
public class Celebrity private constructor(builder: Builder) {
    /**
     * Provides information about the celebrity's face, such as its location on the image.
     */
    public val face: aws.sdk.kotlin.services.rekognition.model.ComparedFace? = builder.face
    /**
     * A unique identifier for the celebrity.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.
     */
    public val knownGender: aws.sdk.kotlin.services.rekognition.model.KnownGender? = builder.knownGender
    /**
     * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     */
    public val matchConfidence: kotlin.Float? = builder.matchConfidence
    /**
     * The name of the celebrity.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.
     */
    public val urls: List<String>? = builder.urls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.Celebrity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Celebrity(")
        append("face=$face,")
        append("id=$id,")
        append("knownGender=$knownGender,")
        append("matchConfidence=$matchConfidence,")
        append("name=$name,")
        append("urls=$urls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = face?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (knownGender?.hashCode() ?: 0)
        result = 31 * result + (matchConfidence?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (urls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Celebrity

        if (face != other.face) return false
        if (id != other.id) return false
        if (knownGender != other.knownGender) return false
        if (matchConfidence != other.matchConfidence) return false
        if (name != other.name) return false
        if (urls != other.urls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.Celebrity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides information about the celebrity's face, such as its location on the image.
         */
        public var face: aws.sdk.kotlin.services.rekognition.model.ComparedFace? = null
        /**
         * A unique identifier for the celebrity.
         */
        public var id: kotlin.String? = null
        /**
         * The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.
         */
        public var knownGender: aws.sdk.kotlin.services.rekognition.model.KnownGender? = null
        /**
         * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         */
        public var matchConfidence: kotlin.Float? = null
        /**
         * The name of the celebrity.
         */
        public var name: kotlin.String? = null
        /**
         * An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.
         */
        public var urls: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.Celebrity) : this() {
            this.face = x.face
            this.id = x.id
            this.knownGender = x.knownGender
            this.matchConfidence = x.matchConfidence
            this.name = x.name
            this.urls = x.urls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.Celebrity = Celebrity(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ComparedFace] inside the given [block]
         */
        public fun face(block: aws.sdk.kotlin.services.rekognition.model.ComparedFace.Builder.() -> kotlin.Unit) {
            this.face = aws.sdk.kotlin.services.rekognition.model.ComparedFace.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.KnownGender] inside the given [block]
         */
        public fun knownGender(block: aws.sdk.kotlin.services.rekognition.model.KnownGender.Builder.() -> kotlin.Unit) {
            this.knownGender = aws.sdk.kotlin.services.rekognition.model.KnownGender.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
