// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An image that is picked from the Face Liveness video and returned for audit trail purposes, returned as Base64-encoded bytes.
 */
public class AuditImage private constructor(builder: Builder) {
    /**
     * Identifies the bounding box around the label, face, text, object of interest, or personal protective equipment. The `left` (x-coordinate) and `top` (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
     *
     * The `top` and `left` values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a `left` value of 0.5 (350/700) and a `top` value of 0.25 (50/200).
     *
     * The `width` and `height` values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1.
     *
     *  The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the `left` or `top` values.
     */
    public val boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = builder.boundingBox
    /**
     * The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for audit purposes.
     */
    public val bytes: kotlin.ByteArray? = builder.bytes
    /**
     * Provides the S3 bucket name and object name.
     *
     * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
     *
     * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
     */
    public val s3Object: aws.sdk.kotlin.services.rekognition.model.S3Object? = builder.s3Object

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.AuditImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuditImage(")
        append("boundingBox=$boundingBox,")
        append("bytes=*** Sensitive Data Redacted ***,")
        append("s3Object=$s3Object")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boundingBox?.hashCode() ?: 0
        result = 31 * result + (bytes?.contentHashCode() ?: 0)
        result = 31 * result + (s3Object?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuditImage

        if (boundingBox != other.boundingBox) return false
        if (bytes != null) {
            if (other.bytes == null) return false
            if (!bytes.contentEquals(other.bytes)) return false
        } else if (other.bytes != null) return false
        if (s3Object != other.s3Object) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.AuditImage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifies the bounding box around the label, face, text, object of interest, or personal protective equipment. The `left` (x-coordinate) and `top` (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
         *
         * The `top` and `left` values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a `left` value of 0.5 (350/700) and a `top` value of 0.25 (50/200).
         *
         * The `width` and `height` values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1.
         *
         *  The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the `left` or `top` values.
         */
        public var boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = null
        /**
         * The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for audit purposes.
         */
        public var bytes: kotlin.ByteArray? = null
        /**
         * Provides the S3 bucket name and object name.
         *
         * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
         *
         * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
         */
        public var s3Object: aws.sdk.kotlin.services.rekognition.model.S3Object? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.AuditImage) : this() {
            this.boundingBox = x.boundingBox
            this.bytes = x.bytes
            this.s3Object = x.s3Object
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.AuditImage = AuditImage(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.BoundingBox] inside the given [block]
         */
        public fun boundingBox(block: aws.sdk.kotlin.services.rekognition.model.BoundingBox.Builder.() -> kotlin.Unit) {
            this.boundingBox = aws.sdk.kotlin.services.rekognition.model.BoundingBox.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.S3Object] inside the given [block]
         */
        public fun s3Object(block: aws.sdk.kotlin.services.rekognition.model.S3Object.Builder.() -> kotlin.Unit) {
            this.s3Object = aws.sdk.kotlin.services.rekognition.model.S3Object.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
