// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Structure containing the estimated age range, in years, for a face.
 *
 * Amazon Rekognition estimates an age range for faces detected in the input image. Estimated age ranges can overlap. A face of a 5-year-old might have an estimated range of 4-6, while the face of a 6-year-old might have an estimated range of 4-8.
 */
public class AgeRange private constructor(builder: Builder) {
    /**
     * The highest estimated age.
     */
    public val high: kotlin.Int? = builder.high
    /**
     * The lowest estimated age.
     */
    public val low: kotlin.Int? = builder.low

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.AgeRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgeRange(")
        append("high=$high,")
        append("low=$low")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = high ?: 0
        result = 31 * result + (low ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgeRange

        if (high != other.high) return false
        if (low != other.low) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.AgeRange = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The highest estimated age.
         */
        public var high: kotlin.Int? = null
        /**
         * The lowest estimated age.
         */
        public var low: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.AgeRange) : this() {
            this.high = x.high
            this.low = x.low
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.AgeRange = AgeRange(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
