// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.waiters

import aws.sdk.kotlin.services.rekognition.RekognitionClient
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until the ProjectVersion is running.
 */
public suspend fun RekognitionClient.waitUntilProjectVersionRunning(request: DescribeProjectVersionsRequest): Outcome<DescribeProjectVersionsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeProjectVersionsRequest, DescribeProjectVersionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val projectVersionDescriptions = it.projectVersionDescriptions
            val projectVersionDescriptionsOrEmpty = projectVersionDescriptions?.flattenIfPossible()
            val projection = projectVersionDescriptionsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "RUNNING" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val projectVersionDescriptions = it.projectVersionDescriptions
            val projectVersionDescriptionsOrEmpty = projectVersionDescriptions?.flattenIfPossible()
            val projection = projectVersionDescriptionsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeProjectVersions(request) }
}

/**
 * Wait until the ProjectVersion is running.
 */
public suspend fun RekognitionClient.waitUntilProjectVersionRunning(block: DescribeProjectVersionsRequest.Builder.() -> Unit): Outcome<DescribeProjectVersionsResponse> =
    waitUntilProjectVersionRunning(DescribeProjectVersionsRequest.Builder().apply(block).build())

/**
 * Wait until the ProjectVersion training completes.
 */
public suspend fun RekognitionClient.waitUntilProjectVersionTrainingCompleted(request: DescribeProjectVersionsRequest): Outcome<DescribeProjectVersionsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 120_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeProjectVersionsRequest, DescribeProjectVersionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val projectVersionDescriptions = it.projectVersionDescriptions
            val projectVersionDescriptionsOrEmpty = projectVersionDescriptions?.flattenIfPossible()
            val projection = projectVersionDescriptionsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "TRAINING_COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val projectVersionDescriptions = it.projectVersionDescriptions
            val projectVersionDescriptionsOrEmpty = projectVersionDescriptions?.flattenIfPossible()
            val projection = projectVersionDescriptionsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "TRAINING_FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeProjectVersions(request) }
}

/**
 * Wait until the ProjectVersion training completes.
 */
public suspend fun RekognitionClient.waitUntilProjectVersionTrainingCompleted(block: DescribeProjectVersionsRequest.Builder.() -> Unit): Outcome<DescribeProjectVersionsResponse> =
    waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest.Builder().apply(block).build())
