// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.GetMediaAnalysisJobResponse
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobStatus
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig
import aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetMediaAnalysisJobOperationDeserializer: HttpDeserialize<GetMediaAnalysisJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMediaAnalysisJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMediaAnalysisJobError(context, call)
        }
        val builder = GetMediaAnalysisJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMediaAnalysisJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMediaAnalysisJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMediaAnalysisJobOperationBody(builder: GetMediaAnalysisJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionTimestamp"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTimestamp"))
    val FAILUREDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FailureDetails"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Input"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobName"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val MANIFESTSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ManifestSummary"))
    val OPERATIONSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OperationsConfig"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Results"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETIONTIMESTAMP_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(FAILUREDETAILS_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(MANIFESTSUMMARY_DESCRIPTOR)
        field(OPERATIONSCONFIG_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(RESULTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETIONTIMESTAMP_DESCRIPTOR.index -> builder.completionTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREDETAILS_DESCRIPTOR.index -> builder.failureDetails = deserializeMediaAnalysisJobFailureDetailsDocument(deserializer)
                INPUT_DESCRIPTOR.index -> builder.input = deserializeMediaAnalysisInputDocument(deserializer)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                MANIFESTSUMMARY_DESCRIPTOR.index -> builder.manifestSummary = deserializeMediaAnalysisManifestSummaryDocument(deserializer)
                OPERATIONSCONFIG_DESCRIPTOR.index -> builder.operationsConfig = deserializeMediaAnalysisOperationsConfigDocument(deserializer)
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeMediaAnalysisOutputConfigDocument(deserializer)
                RESULTS_DESCRIPTOR.index -> builder.results = deserializeMediaAnalysisResultsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MediaAnalysisJobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
