// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.GetFaceSearchResponse
import aws.sdk.kotlin.services.rekognition.model.PersonMatch
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.Video
import aws.sdk.kotlin.services.rekognition.model.VideoJobStatus
import aws.sdk.kotlin.services.rekognition.model.VideoMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetFaceSearchOperationDeserializer: HttpDeserialize<GetFaceSearchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetFaceSearchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFaceSearchError(context, call)
        }
        val builder = GetFaceSearchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFaceSearchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetFaceSearchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFaceSearchOperationBody(builder: GetFaceSearchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val JOBTAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobTag"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PERSONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Persons"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val VIDEO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Video"))
    val VIDEOMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VideoMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(JOBTAG_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PERSONS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(VIDEO_DESCRIPTOR)
        field(VIDEOMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { VideoJobStatus.fromValue(it) }
                JOBTAG_DESCRIPTOR.index -> builder.jobTag = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PERSONS_DESCRIPTOR.index -> builder.persons =
                    deserializer.deserializeList(PERSONS_DESCRIPTOR) {
                        val col0 = mutableListOf<PersonMatch>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePersonMatchDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                VIDEO_DESCRIPTOR.index -> builder.video = deserializeVideoDocument(deserializer)
                VIDEOMETADATA_DESCRIPTOR.index -> builder.videoMetadata = deserializeVideoMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
