// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.DisassociateFacesResponse
import aws.sdk.kotlin.services.rekognition.model.DisassociatedFace
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.UnsuccessfulFaceDisassociation
import aws.sdk.kotlin.services.rekognition.model.UserStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DisassociateFacesOperationDeserializer: HttpDeserialize<DisassociateFacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DisassociateFacesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDisassociateFacesError(context, call)
        }
        val builder = DisassociateFacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisassociateFacesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDisassociateFacesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisassociateFacesOperationBody(builder: DisassociateFacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISASSOCIATEDFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DisassociatedFaces"))
    val UNSUCCESSFULFACEDISASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnsuccessfulFaceDisassociations"))
    val USERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UserStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISASSOCIATEDFACES_DESCRIPTOR)
        field(UNSUCCESSFULFACEDISASSOCIATIONS_DESCRIPTOR)
        field(USERSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISASSOCIATEDFACES_DESCRIPTOR.index -> builder.disassociatedFaces =
                    deserializer.deserializeList(DISASSOCIATEDFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<DisassociatedFace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDisassociatedFaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNSUCCESSFULFACEDISASSOCIATIONS_DESCRIPTOR.index -> builder.unsuccessfulFaceDisassociations =
                    deserializer.deserializeList(UNSUCCESSFULFACEDISASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnsuccessfulFaceDisassociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnsuccessfulFaceDisassociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERSTATUS_DESCRIPTOR.index -> builder.userStatus = deserializeString().let { UserStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
