// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.DetectLabelsFeatureName
import aws.sdk.kotlin.services.rekognition.model.DetectLabelsRequest
import aws.sdk.kotlin.services.rekognition.model.DetectLabelsSettings
import aws.sdk.kotlin.services.rekognition.model.Image
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DetectLabelsOperationSerializer: HttpSerialize<DetectLabelsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DetectLabelsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDetectLabelsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeDetectLabelsOperationBody(context: ExecutionContext, input: DetectLabelsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Features"))
    val IMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Image"))
    val MAXLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxLabels"))
    val MINCONFIDENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("MinConfidence"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Settings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FEATURES_DESCRIPTOR)
        field(IMAGE_DESCRIPTOR)
        field(MAXLABELS_DESCRIPTOR)
        field(MINCONFIDENCE_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.features != null) {
            listField(FEATURES_DESCRIPTOR) {
                for (el0 in input.features) {
                    serializeString(el0.value)
                }
            }
        }
        input.image?.let { field(IMAGE_DESCRIPTOR, it, ::serializeImageDocument) }
        input.maxLabels?.let { field(MAXLABELS_DESCRIPTOR, it) }
        input.minConfidence?.let { field(MINCONFIDENCE_DESCRIPTOR, it) }
        input.settings?.let { field(SETTINGS_DESCRIPTOR, it, ::serializeDetectLabelsSettingsDocument) }
    }
    return serializer.toByteArray()
}
