// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.DescribeStreamProcessorResponse
import aws.sdk.kotlin.services.rekognition.model.RegionOfInterest
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorDataSharingPreference
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorInput
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings
import aws.sdk.kotlin.services.rekognition.model.StreamProcessorStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeStreamProcessorOperationDeserializer: HttpDeserialize<DescribeStreamProcessorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeStreamProcessorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStreamProcessorError(context, call)
        }
        val builder = DescribeStreamProcessorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStreamProcessorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeStreamProcessorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStreamProcessorOperationBody(builder: DescribeStreamProcessorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTimestamp"))
    val DATASHARINGPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSharingPreference"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Input"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LASTUPDATETIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdateTimestamp"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val NOTIFICATIONCHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationChannel"))
    val OUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Output"))
    val REGIONSOFINTEREST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RegionsOfInterest"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Settings"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val STREAMPROCESSORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamProcessorArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DATASHARINGPREFERENCE_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTUPDATETIMESTAMP_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NOTIFICATIONCHANNEL_DESCRIPTOR)
        field(OUTPUT_DESCRIPTOR)
        field(REGIONSOFINTEREST_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(STREAMPROCESSORARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATASHARINGPREFERENCE_DESCRIPTOR.index -> builder.dataSharingPreference = deserializeStreamProcessorDataSharingPreferenceDocument(deserializer)
                INPUT_DESCRIPTOR.index -> builder.input = deserializeStreamProcessorInputDocument(deserializer)
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTUPDATETIMESTAMP_DESCRIPTOR.index -> builder.lastUpdateTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NOTIFICATIONCHANNEL_DESCRIPTOR.index -> builder.notificationChannel = deserializeStreamProcessorNotificationChannelDocument(deserializer)
                OUTPUT_DESCRIPTOR.index -> builder.output = deserializeStreamProcessorOutputDocument(deserializer)
                REGIONSOFINTEREST_DESCRIPTOR.index -> builder.regionsOfInterest =
                    deserializer.deserializeList(REGIONSOFINTEREST_DESCRIPTOR) {
                        val col0 = mutableListOf<RegionOfInterest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRegionOfInterestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SETTINGS_DESCRIPTOR.index -> builder.settings = deserializeStreamProcessorSettingsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StreamProcessorStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                STREAMPROCESSORARN_DESCRIPTOR.index -> builder.streamProcessorArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
