// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.CreateCollectionResponse
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCollectionOperationDeserializer: HttpDeserialize<CreateCollectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateCollectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCollectionError(context, call)
        }
        val builder = CreateCollectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCollectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateCollectionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCollectionOperationBody(builder: CreateCollectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLECTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CollectionArn"))
    val FACEMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FaceModelVersion"))
    val STATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StatusCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLECTIONARN_DESCRIPTOR)
        field(FACEMODELVERSION_DESCRIPTOR)
        field(STATUSCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLECTIONARN_DESCRIPTOR.index -> builder.collectionArn = deserializeString()
                FACEMODELVERSION_DESCRIPTOR.index -> builder.faceModelVersion = deserializeString()
                STATUSCODE_DESCRIPTOR.index -> builder.statusCode = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
