// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.CompareFacesMatch
import aws.sdk.kotlin.services.rekognition.model.CompareFacesResponse
import aws.sdk.kotlin.services.rekognition.model.ComparedFace
import aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace
import aws.sdk.kotlin.services.rekognition.model.OrientationCorrection
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CompareFacesOperationDeserializer: HttpDeserialize<CompareFacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CompareFacesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCompareFacesError(context, call)
        }
        val builder = CompareFacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCompareFacesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCompareFacesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCompareFacesOperationBody(builder: CompareFacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACEMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FaceMatches"))
    val SOURCEIMAGEFACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceImageFace"))
    val SOURCEIMAGEORIENTATIONCORRECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SourceImageOrientationCorrection"))
    val TARGETIMAGEORIENTATIONCORRECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TargetImageOrientationCorrection"))
    val UNMATCHEDFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnmatchedFaces"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACEMATCHES_DESCRIPTOR)
        field(SOURCEIMAGEFACE_DESCRIPTOR)
        field(SOURCEIMAGEORIENTATIONCORRECTION_DESCRIPTOR)
        field(TARGETIMAGEORIENTATIONCORRECTION_DESCRIPTOR)
        field(UNMATCHEDFACES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACEMATCHES_DESCRIPTOR.index -> builder.faceMatches =
                    deserializer.deserializeList(FACEMATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<CompareFacesMatch>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCompareFacesMatchDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOURCEIMAGEFACE_DESCRIPTOR.index -> builder.sourceImageFace = deserializeComparedSourceImageFaceDocument(deserializer)
                SOURCEIMAGEORIENTATIONCORRECTION_DESCRIPTOR.index -> builder.sourceImageOrientationCorrection = deserializeString().let { OrientationCorrection.fromValue(it) }
                TARGETIMAGEORIENTATIONCORRECTION_DESCRIPTOR.index -> builder.targetImageOrientationCorrection = deserializeString().let { OrientationCorrection.fromValue(it) }
                UNMATCHEDFACES_DESCRIPTOR.index -> builder.unmatchedFaces =
                    deserializer.deserializeList(UNMATCHEDFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<ComparedFace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeComparedFaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
