// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Information about a video that Amazon Rekognition analyzed. `Videometadata` is returned in every page of paginated responses from a Amazon Rekognition video operation.
 */
public class VideoMetadata private constructor(builder: Builder) {
    /**
     * Type of compression used in the analyzed video.
     */
    public val codec: kotlin.String? = builder.codec
    /**
     * A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255).
     */
    public val colorRange: aws.sdk.kotlin.services.rekognition.model.VideoColorRange? = builder.colorRange
    /**
     * Length of the video in milliseconds.
     */
    public val durationMillis: kotlin.Long? = builder.durationMillis
    /**
     * Format of the analyzed video. Possible values are MP4, MOV and AVI.
     */
    public val format: kotlin.String? = builder.format
    /**
     * Vertical pixel dimension of the video.
     */
    public val frameHeight: kotlin.Long? = builder.frameHeight
    /**
     * Number of frames per second in the video.
     */
    public val frameRate: kotlin.Float? = builder.frameRate
    /**
     * Horizontal pixel dimension of the video.
     */
    public val frameWidth: kotlin.Long? = builder.frameWidth

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.VideoMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoMetadata(")
        append("codec=$codec,")
        append("colorRange=$colorRange,")
        append("durationMillis=$durationMillis,")
        append("format=$format,")
        append("frameHeight=$frameHeight,")
        append("frameRate=$frameRate,")
        append("frameWidth=$frameWidth")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codec?.hashCode() ?: 0
        result = 31 * result + (colorRange?.hashCode() ?: 0)
        result = 31 * result + (durationMillis?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (frameHeight?.hashCode() ?: 0)
        result = 31 * result + (frameRate?.hashCode() ?: 0)
        result = 31 * result + (frameWidth?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoMetadata

        if (codec != other.codec) return false
        if (colorRange != other.colorRange) return false
        if (durationMillis != other.durationMillis) return false
        if (format != other.format) return false
        if (frameHeight != other.frameHeight) return false
        if (frameRate != other.frameRate) return false
        if (frameWidth != other.frameWidth) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.VideoMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Type of compression used in the analyzed video.
         */
        public var codec: kotlin.String? = null
        /**
         * A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255).
         */
        public var colorRange: aws.sdk.kotlin.services.rekognition.model.VideoColorRange? = null
        /**
         * Length of the video in milliseconds.
         */
        public var durationMillis: kotlin.Long? = null
        /**
         * Format of the analyzed video. Possible values are MP4, MOV and AVI.
         */
        public var format: kotlin.String? = null
        /**
         * Vertical pixel dimension of the video.
         */
        public var frameHeight: kotlin.Long? = null
        /**
         * Number of frames per second in the video.
         */
        public var frameRate: kotlin.Float? = null
        /**
         * Horizontal pixel dimension of the video.
         */
        public var frameWidth: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.VideoMetadata) : this() {
            this.codec = x.codec
            this.colorRange = x.colorRange
            this.durationMillis = x.durationMillis
            this.format = x.format
            this.frameHeight = x.frameHeight
            this.frameRate = x.frameRate
            this.frameWidth = x.frameWidth
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.VideoMetadata = VideoMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
