// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Information about a word or line of text detected by DetectText.
 *
 * The `DetectedText` field contains the text that Amazon Rekognition detected in the image.
 *
 * Every word and line has an identifier (`Id`). Each word belongs to a line and has a parent identifier (`ParentId`) that identifies the line of text in which the word appears. The word `Id` is also an index for the word within a line of words.
 *
 * For more information, see Detecting text in the Amazon Rekognition Developer Guide.
 */
public class TextDetection private constructor(builder: Builder) {
    /**
     * The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * The word or line of text recognized by Amazon Rekognition.
     */
    public val detectedText: kotlin.String? = builder.detectedText
    /**
     * The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.
     */
    public val geometry: aws.sdk.kotlin.services.rekognition.model.Geometry? = builder.geometry
    /**
     * The identifier for the detected text. The identifier is only unique for a single call to `DetectText`.
     */
    public val id: kotlin.Int? = builder.id
    /**
     * The Parent identifier for the detected text identified by the value of `ID`. If the type of detected text is `LINE`, the value of `ParentId` is `Null`.
     */
    public val parentId: kotlin.Int? = builder.parentId
    /**
     * The type of text that was detected.
     */
    public val type: aws.sdk.kotlin.services.rekognition.model.TextTypes? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.TextDetection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TextDetection(")
        append("confidence=$confidence,")
        append("detectedText=$detectedText,")
        append("geometry=$geometry,")
        append("id=$id,")
        append("parentId=$parentId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence?.hashCode() ?: 0
        result = 31 * result + (detectedText?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        result = 31 * result + (id ?: 0)
        result = 31 * result + (parentId ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TextDetection

        if (confidence != other.confidence) return false
        if (detectedText != other.detectedText) return false
        if (geometry != other.geometry) return false
        if (id != other.id) return false
        if (parentId != other.parentId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.TextDetection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.
         */
        public var confidence: kotlin.Float? = null
        /**
         * The word or line of text recognized by Amazon Rekognition.
         */
        public var detectedText: kotlin.String? = null
        /**
         * The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.
         */
        public var geometry: aws.sdk.kotlin.services.rekognition.model.Geometry? = null
        /**
         * The identifier for the detected text. The identifier is only unique for a single call to `DetectText`.
         */
        public var id: kotlin.Int? = null
        /**
         * The Parent identifier for the detected text identified by the value of `ID`. If the type of detected text is `LINE`, the value of `ParentId` is `Null`.
         */
        public var parentId: kotlin.Int? = null
        /**
         * The type of text that was detected.
         */
        public var type: aws.sdk.kotlin.services.rekognition.model.TextTypes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.TextDetection) : this() {
            this.confidence = x.confidence
            this.detectedText = x.detectedText
            this.geometry = x.geometry
            this.id = x.id
            this.parentId = x.parentId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.TextDetection = TextDetection(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Geometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.rekognition.model.Geometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.rekognition.model.Geometry.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
