// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Input parameters used in a streaming video analyzed by a Amazon Rekognition stream processor. You can use `FaceSearch` to recognize faces in a streaming video, or you can use `ConnectedHome` to detect labels.
 */
public class StreamProcessorSettings private constructor(builder: Builder) {
    /**
     * Label detection settings to use on a streaming video. Defining the settings is required in the request parameter for CreateStreamProcessor. Including this setting in the `CreateStreamProcessor` request enables you to use the stream processor for label detection. You can then select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For example, if packages and pets are selected, one SNS notification is published the first time a package is detected and one SNS notification is published the first time a pet is detected, as well as an end-of-session summary.
     */
    public val connectedHome: aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings? = builder.connectedHome
    /**
     * Face search settings to use on a streaming video.
     */
    public val faceSearch: aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings? = builder.faceSearch

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamProcessorSettings(")
        append("connectedHome=$connectedHome,")
        append("faceSearch=$faceSearch")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectedHome?.hashCode() ?: 0
        result = 31 * result + (faceSearch?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamProcessorSettings

        if (connectedHome != other.connectedHome) return false
        if (faceSearch != other.faceSearch) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Label detection settings to use on a streaming video. Defining the settings is required in the request parameter for CreateStreamProcessor. Including this setting in the `CreateStreamProcessor` request enables you to use the stream processor for label detection. You can then select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For example, if packages and pets are selected, one SNS notification is published the first time a package is detected and one SNS notification is published the first time a pet is detected, as well as an end-of-session summary.
         */
        public var connectedHome: aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings? = null
        /**
         * Face search settings to use on a streaming video.
         */
        public var faceSearch: aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings) : this() {
            this.connectedHome = x.connectedHome
            this.faceSearch = x.faceSearch
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StreamProcessorSettings = StreamProcessorSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings] inside the given [block]
         */
        public fun connectedHome(block: aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings.Builder.() -> kotlin.Unit) {
            this.connectedHome = aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings] inside the given [block]
         */
        public fun faceSearch(block: aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings.Builder.() -> kotlin.Unit) {
            this.faceSearch = aws.sdk.kotlin.services.rekognition.model.FaceSearchSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
