// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
 *
 * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.
 *
 * Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.
 */
public class StreamProcessorNotificationChannel private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
     */
    public val snsTopicArn: kotlin.String = requireNotNull(builder.snsTopicArn) { "A non-null value must be provided for snsTopicArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamProcessorNotificationChannel(")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = snsTopicArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamProcessorNotificationChannel

        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel) : this() {
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StreamProcessorNotificationChannel = StreamProcessorNotificationChannel(this)

        internal fun correctErrors(): Builder {
            if (snsTopicArn == null) snsTopicArn = ""
            return this
        }
    }
}
