// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class StartStreamProcessorRequest private constructor(builder: Builder) {
    /**
     * The name of the stream processor to start processing.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the fragment number. If you use the producer timestamp, you must put the time in milliseconds. For more information about fragment numbers, see [Fragment](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html).
     *
     * This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.
     */
    public val startSelector: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStartSelector? = builder.startSelector
    /**
     * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
     *
     * This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.
     */
    public val stopSelector: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStopSelector? = builder.stopSelector

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartStreamProcessorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartStreamProcessorRequest(")
        append("name=$name,")
        append("startSelector=$startSelector,")
        append("stopSelector=$stopSelector")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (startSelector?.hashCode() ?: 0)
        result = 31 * result + (stopSelector?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartStreamProcessorRequest

        if (name != other.name) return false
        if (startSelector != other.startSelector) return false
        if (stopSelector != other.stopSelector) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartStreamProcessorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the stream processor to start processing.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the fragment number. If you use the producer timestamp, you must put the time in milliseconds. For more information about fragment numbers, see [Fragment](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html).
         *
         * This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.
         */
        public var startSelector: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStartSelector? = null
        /**
         * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
         *
         * This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.
         */
        public var stopSelector: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStopSelector? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartStreamProcessorRequest) : this() {
            this.name = x.name
            this.startSelector = x.startSelector
            this.stopSelector = x.stopSelector
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartStreamProcessorRequest = StartStreamProcessorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessingStartSelector] inside the given [block]
         */
        public fun startSelector(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStartSelector.Builder.() -> kotlin.Unit) {
            this.startSelector = aws.sdk.kotlin.services.rekognition.model.StreamProcessingStartSelector.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StreamProcessingStopSelector] inside the given [block]
         */
        public fun stopSelector(block: aws.sdk.kotlin.services.rekognition.model.StreamProcessingStopSelector.Builder.() -> kotlin.Unit) {
            this.stopSelector = aws.sdk.kotlin.services.rekognition.model.StreamProcessingStopSelector.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
