// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class StartSegmentDetectionRequest private constructor(builder: Builder) {
    /**
     * Idempotent token used to identify the start request. If you use the same token with multiple `StartSegmentDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Filters for technical cue or shot detection.
     */
    public val filters: aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionFilters? = builder.filters
    /**
     * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
     */
    public val notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = builder.notificationChannel
    /**
     * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
     */
    public val segmentTypes: List<SegmentType>? = builder.segmentTypes
    /**
     * Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as StartLabelDetection use `Video` to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.
     */
    public val video: aws.sdk.kotlin.services.rekognition.model.Video? = builder.video

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSegmentDetectionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("filters=$filters,")
        append("jobTag=$jobTag,")
        append("notificationChannel=$notificationChannel,")
        append("segmentTypes=$segmentTypes,")
        append("video=$video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (segmentTypes?.hashCode() ?: 0)
        result = 31 * result + (video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSegmentDetectionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (filters != other.filters) return false
        if (jobTag != other.jobTag) return false
        if (notificationChannel != other.notificationChannel) return false
        if (segmentTypes != other.segmentTypes) return false
        if (video != other.video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Idempotent token used to identify the start request. If you use the same token with multiple `StartSegmentDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Filters for technical cue or shot detection.
         */
        public var filters: aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionFilters? = null
        /**
         * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
         */
        public var jobTag: kotlin.String? = null
        /**
         * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
         */
        public var notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = null
        /**
         * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         */
        public var segmentTypes: List<SegmentType>? = null
        /**
         * Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as StartLabelDetection use `Video` to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.
         */
        public var video: aws.sdk.kotlin.services.rekognition.model.Video? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.filters = x.filters
            this.jobTag = x.jobTag
            this.notificationChannel = x.notificationChannel
            this.segmentTypes = x.segmentTypes
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionRequest = StartSegmentDetectionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionFilters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionFilters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.rekognition.model.StartSegmentDetectionFilters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.rekognition.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.rekognition.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Video] inside the given [block]
         */
        public fun video(block: aws.sdk.kotlin.services.rekognition.model.Video.Builder.() -> kotlin.Unit) {
            this.video = aws.sdk.kotlin.services.rekognition.model.Video.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
