// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class StartContentModerationRequest private constructor(builder: Builder) {
    /**
     * Idempotent token used to identify the start request. If you use the same token with multiple `StartContentModeration` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated content labels with a confidence level lower than this specified value. If you don't specify `MinConfidence`, `GetContentModeration` returns labels with confidence values greater than or equal to 50 percent.
     */
    public val minConfidence: kotlin.Float? = builder.minConfidence
    /**
     * The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the content analysis to. The Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
     */
    public val notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = builder.notificationChannel
    /**
     * The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored in an Amazon S3 bucket.
     */
    public val video: aws.sdk.kotlin.services.rekognition.model.Video? = builder.video

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartContentModerationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartContentModerationRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("jobTag=$jobTag,")
        append("minConfidence=$minConfidence,")
        append("notificationChannel=$notificationChannel,")
        append("video=$video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (minConfidence?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartContentModerationRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (jobTag != other.jobTag) return false
        if (minConfidence != other.minConfidence) return false
        if (notificationChannel != other.notificationChannel) return false
        if (video != other.video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartContentModerationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Idempotent token used to identify the start request. If you use the same token with multiple `StartContentModeration` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
         */
        public var jobTag: kotlin.String? = null
        /**
         * Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated content labels with a confidence level lower than this specified value. If you don't specify `MinConfidence`, `GetContentModeration` returns labels with confidence values greater than or equal to 50 percent.
         */
        public var minConfidence: kotlin.Float? = null
        /**
         * The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the content analysis to. The Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
         */
        public var notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = null
        /**
         * The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored in an Amazon S3 bucket.
         */
        public var video: aws.sdk.kotlin.services.rekognition.model.Video? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartContentModerationRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.jobTag = x.jobTag
            this.minConfidence = x.minConfidence
            this.notificationChannel = x.notificationChannel
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartContentModerationRequest = StartContentModerationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.rekognition.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.rekognition.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Video] inside the given [block]
         */
        public fun video(block: aws.sdk.kotlin.services.rekognition.model.Video.Builder.() -> kotlin.Unit) {
            this.video = aws.sdk.kotlin.services.rekognition.model.Video.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
