// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * A technical cue or shot detection segment detected in a video. An array of `SegmentDetection` objects containing all segments detected in a stored video is returned by GetSegmentDetection.
 */
public class SegmentDetection private constructor(builder: Builder) {
    /**
     * The duration of a video segment, expressed in frames.
     */
    public val durationFrames: kotlin.Long? = builder.durationFrames
    /**
     * The duration of the detected segment in milliseconds.
     */
    public val durationMillis: kotlin.Long? = builder.durationMillis
    /**
     * The duration of the timecode for the detected segment in SMPTE format.
     */
    public val durationSmpte: kotlin.String? = builder.durationSmpte
    /**
     * The frame number at the end of a video segment, using a frame index that starts with 0.
     */
    public val endFrameNumber: kotlin.Long? = builder.endFrameNumber
    /**
     * The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. `EndTimecode` is in *HH:MM:SS:fr* format (and *;fr* for drop frame-rates).
     */
    public val endTimecodeSmpte: kotlin.String? = builder.endTimecodeSmpte
    /**
     * The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.
     */
    public val endTimestampMillis: kotlin.Long = builder.endTimestampMillis
    /**
     * If the segment is a shot detection, contains information about the shot detection.
     */
    public val shotSegment: aws.sdk.kotlin.services.rekognition.model.ShotSegment? = builder.shotSegment
    /**
     * The frame number of the start of a video segment, using a frame index that starts with 0.
     */
    public val startFrameNumber: kotlin.Long? = builder.startFrameNumber
    /**
     * The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. `StartTimecode` is in *HH:MM:SS:fr* format (and *;fr* for drop frame-rates).
     */
    public val startTimecodeSmpte: kotlin.String? = builder.startTimecodeSmpte
    /**
     * The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.
     */
    public val startTimestampMillis: kotlin.Long = builder.startTimestampMillis
    /**
     * If the segment is a technical cue, contains information about the technical cue.
     */
    public val technicalCueSegment: aws.sdk.kotlin.services.rekognition.model.TechnicalCueSegment? = builder.technicalCueSegment
    /**
     * The type of the segment. Valid values are `TECHNICAL_CUE` and `SHOT`.
     */
    public val type: aws.sdk.kotlin.services.rekognition.model.SegmentType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.SegmentDetection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SegmentDetection(")
        append("durationFrames=$durationFrames,")
        append("durationMillis=$durationMillis,")
        append("durationSmpte=$durationSmpte,")
        append("endFrameNumber=$endFrameNumber,")
        append("endTimecodeSmpte=$endTimecodeSmpte,")
        append("endTimestampMillis=$endTimestampMillis,")
        append("shotSegment=$shotSegment,")
        append("startFrameNumber=$startFrameNumber,")
        append("startTimecodeSmpte=$startTimecodeSmpte,")
        append("startTimestampMillis=$startTimestampMillis,")
        append("technicalCueSegment=$technicalCueSegment,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationFrames?.hashCode() ?: 0
        result = 31 * result + (durationMillis?.hashCode() ?: 0)
        result = 31 * result + (durationSmpte?.hashCode() ?: 0)
        result = 31 * result + (endFrameNumber?.hashCode() ?: 0)
        result = 31 * result + (endTimecodeSmpte?.hashCode() ?: 0)
        result = 31 * result + (endTimestampMillis.hashCode())
        result = 31 * result + (shotSegment?.hashCode() ?: 0)
        result = 31 * result + (startFrameNumber?.hashCode() ?: 0)
        result = 31 * result + (startTimecodeSmpte?.hashCode() ?: 0)
        result = 31 * result + (startTimestampMillis.hashCode())
        result = 31 * result + (technicalCueSegment?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SegmentDetection

        if (durationFrames != other.durationFrames) return false
        if (durationMillis != other.durationMillis) return false
        if (durationSmpte != other.durationSmpte) return false
        if (endFrameNumber != other.endFrameNumber) return false
        if (endTimecodeSmpte != other.endTimecodeSmpte) return false
        if (endTimestampMillis != other.endTimestampMillis) return false
        if (shotSegment != other.shotSegment) return false
        if (startFrameNumber != other.startFrameNumber) return false
        if (startTimecodeSmpte != other.startTimecodeSmpte) return false
        if (startTimestampMillis != other.startTimestampMillis) return false
        if (technicalCueSegment != other.technicalCueSegment) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.SegmentDetection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The duration of a video segment, expressed in frames.
         */
        public var durationFrames: kotlin.Long? = null
        /**
         * The duration of the detected segment in milliseconds.
         */
        public var durationMillis: kotlin.Long? = null
        /**
         * The duration of the timecode for the detected segment in SMPTE format.
         */
        public var durationSmpte: kotlin.String? = null
        /**
         * The frame number at the end of a video segment, using a frame index that starts with 0.
         */
        public var endFrameNumber: kotlin.Long? = null
        /**
         * The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. `EndTimecode` is in *HH:MM:SS:fr* format (and *;fr* for drop frame-rates).
         */
        public var endTimecodeSmpte: kotlin.String? = null
        /**
         * The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.
         */
        public var endTimestampMillis: kotlin.Long = 0L
        /**
         * If the segment is a shot detection, contains information about the shot detection.
         */
        public var shotSegment: aws.sdk.kotlin.services.rekognition.model.ShotSegment? = null
        /**
         * The frame number of the start of a video segment, using a frame index that starts with 0.
         */
        public var startFrameNumber: kotlin.Long? = null
        /**
         * The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. `StartTimecode` is in *HH:MM:SS:fr* format (and *;fr* for drop frame-rates).
         */
        public var startTimecodeSmpte: kotlin.String? = null
        /**
         * The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.
         */
        public var startTimestampMillis: kotlin.Long = 0L
        /**
         * If the segment is a technical cue, contains information about the technical cue.
         */
        public var technicalCueSegment: aws.sdk.kotlin.services.rekognition.model.TechnicalCueSegment? = null
        /**
         * The type of the segment. Valid values are `TECHNICAL_CUE` and `SHOT`.
         */
        public var type: aws.sdk.kotlin.services.rekognition.model.SegmentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.SegmentDetection) : this() {
            this.durationFrames = x.durationFrames
            this.durationMillis = x.durationMillis
            this.durationSmpte = x.durationSmpte
            this.endFrameNumber = x.endFrameNumber
            this.endTimecodeSmpte = x.endTimecodeSmpte
            this.endTimestampMillis = x.endTimestampMillis
            this.shotSegment = x.shotSegment
            this.startFrameNumber = x.startFrameNumber
            this.startTimecodeSmpte = x.startTimecodeSmpte
            this.startTimestampMillis = x.startTimestampMillis
            this.technicalCueSegment = x.technicalCueSegment
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.SegmentDetection = SegmentDetection(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ShotSegment] inside the given [block]
         */
        public fun shotSegment(block: aws.sdk.kotlin.services.rekognition.model.ShotSegment.Builder.() -> kotlin.Unit) {
            this.shotSegment = aws.sdk.kotlin.services.rekognition.model.ShotSegment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TechnicalCueSegment] inside the given [block]
         */
        public fun technicalCueSegment(block: aws.sdk.kotlin.services.rekognition.model.TechnicalCueSegment.Builder.() -> kotlin.Unit) {
            this.technicalCueSegment = aws.sdk.kotlin.services.rekognition.model.TechnicalCueSegment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
