// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class SearchFacesByImageRequest private constructor(builder: Builder) {
    /**
     * ID of the collection to search.
     */
    public val collectionId: kotlin.String? = builder.collectionId
    /**
     * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.
     */
    public val faceMatchThreshold: kotlin.Float? = builder.faceMatchThreshold
    /**
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image
    /**
     * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.
     */
    public val maxFaces: kotlin.Int? = builder.maxFaces
    /**
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed. The default value is `NONE`.
     *
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
     */
    public val qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = builder.qualityFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.SearchFacesByImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchFacesByImageRequest(")
        append("collectionId=$collectionId,")
        append("faceMatchThreshold=$faceMatchThreshold,")
        append("image=$image,")
        append("maxFaces=$maxFaces,")
        append("qualityFilter=$qualityFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionId?.hashCode() ?: 0
        result = 31 * result + (faceMatchThreshold?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (maxFaces ?: 0)
        result = 31 * result + (qualityFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchFacesByImageRequest

        if (collectionId != other.collectionId) return false
        if (faceMatchThreshold != other.faceMatchThreshold) return false
        if (image != other.image) return false
        if (maxFaces != other.maxFaces) return false
        if (qualityFilter != other.qualityFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.SearchFacesByImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ID of the collection to search.
         */
        public var collectionId: kotlin.String? = null
        /**
         * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.
         */
        public var faceMatchThreshold: kotlin.Float? = null
        /**
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.
         */
        public var maxFaces: kotlin.Int? = null
        /**
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed. The default value is `NONE`.
         *
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
         */
        public var qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.SearchFacesByImageRequest) : this() {
            this.collectionId = x.collectionId
            this.faceMatchThreshold = x.faceMatchThreshold
            this.image = x.image
            this.maxFaces = x.maxFaces
            this.qualityFilter = x.qualityFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.SearchFacesByImageRequest = SearchFacesByImageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
