// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Provides the S3 bucket name and object name.
 *
 * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
 *
 * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
 */
public class S3Object private constructor(builder: Builder) {
    /**
     * Name of the S3 bucket.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * S3 object key name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If the bucket is versioning enabled, you can specify the object version.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.S3Object = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Object(")
        append("bucket=$bucket,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Object

        if (bucket != other.bucket) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.S3Object = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Name of the S3 bucket.
         */
        public var bucket: kotlin.String? = null
        /**
         * S3 object key name.
         */
        public var name: kotlin.String? = null
        /**
         * If the bucket is versioning enabled, you can specify the object version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.S3Object) : this() {
            this.bucket = x.bucket
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.S3Object = S3Object(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
