// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Specifies a location within the frame that Rekognition checks for objects of interest such as text, labels, or faces. It uses a `BoundingBox` or `Polygon` to set a region of the screen.
 *
 * A word, face, or label is included in the region if it is more than half in that region. If there is more than one region, the word, face, or label is compared with all regions of the screen. Any object of interest that is more than half in a region is kept in the results.
 */
public class RegionOfInterest private constructor(builder: Builder) {
    /**
     * The box representing a region of interest on screen.
     */
    public val boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = builder.boundingBox
    /**
     * Specifies a shape made up of up to 10 `Point` objects to define a region of interest.
     */
    public val polygon: List<Point>? = builder.polygon

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.RegionOfInterest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegionOfInterest(")
        append("boundingBox=$boundingBox,")
        append("polygon=$polygon")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = boundingBox?.hashCode() ?: 0
        result = 31 * result + (polygon?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegionOfInterest

        if (boundingBox != other.boundingBox) return false
        if (polygon != other.polygon) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.RegionOfInterest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The box representing a region of interest on screen.
         */
        public var boundingBox: aws.sdk.kotlin.services.rekognition.model.BoundingBox? = null
        /**
         * Specifies a shape made up of up to 10 `Point` objects to define a region of interest.
         */
        public var polygon: List<Point>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.RegionOfInterest) : this() {
            this.boundingBox = x.boundingBox
            this.polygon = x.polygon
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.RegionOfInterest = RegionOfInterest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.BoundingBox] inside the given [block]
         */
        public fun boundingBox(block: aws.sdk.kotlin.services.rekognition.model.BoundingBox.Builder.() -> kotlin.Unit) {
            this.boundingBox = aws.sdk.kotlin.services.rekognition.model.BoundingBox.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
