// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class PutProjectPolicyRequest private constructor(builder: Builder) {
    /**
     * A resource policy to add to the model. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see [IAM JSON policy reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * A name for the policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom Labels generates and assigns a new `PolicyRevisionId` and then deletes the previous version of the policy.
     */
    public val policyRevisionId: kotlin.String? = builder.policyRevisionId
    /**
     * The Amazon Resource Name (ARN) of the project that the project policy is attached to.
     */
    public val projectArn: kotlin.String? = builder.projectArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.PutProjectPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutProjectPolicyRequest(")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("policyRevisionId=$policyRevisionId,")
        append("projectArn=$projectArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyDocument?.hashCode() ?: 0
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyRevisionId?.hashCode() ?: 0)
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutProjectPolicyRequest

        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (policyRevisionId != other.policyRevisionId) return false
        if (projectArn != other.projectArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.PutProjectPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A resource policy to add to the model. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see [IAM JSON policy reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
         */
        public var policyDocument: kotlin.String? = null
        /**
         * A name for the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom Labels generates and assigns a new `PolicyRevisionId` and then deletes the previous version of the policy.
         */
        public var policyRevisionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the project that the project policy is attached to.
         */
        public var projectArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.PutProjectPolicyRequest) : this() {
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.policyRevisionId = x.policyRevisionId
            this.projectArn = x.projectArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.PutProjectPolicyRequest = PutProjectPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
