// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see [Calling Amazon Rekognition Video operations](https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html). Note that the Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see [Giving access to multiple Amazon SNS topics](https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics).
 */
public class NotificationChannel private constructor(builder: Builder) {
    /**
     * The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The Amazon SNS topic to which Amazon Rekognition posts the completion status.
     */
    public val snsTopicArn: kotlin.String = requireNotNull(builder.snsTopicArn) { "A non-null value must be provided for snsTopicArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.NotificationChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationChannel(")
        append("roleArn=$roleArn,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (snsTopicArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationChannel

        if (roleArn != other.roleArn) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.NotificationChannel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon SNS topic to which Amazon Rekognition posts the completion status.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.NotificationChannel) : this() {
            this.roleArn = x.roleArn
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.NotificationChannel = NotificationChannel(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (snsTopicArn == null) snsTopicArn = ""
            return this
        }
    }
}
