// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Output configuration provided in the job creation request.
 */
public class MediaAnalysisOutputConfig private constructor(builder: Builder) {
    /**
     * Specifies the Amazon S3 bucket to contain the output of the media analysis job.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for storage.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaAnalysisOutputConfig(")
        append("s3Bucket=$s3Bucket,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket.hashCode()
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaAnalysisOutputConfig

        if (s3Bucket != other.s3Bucket) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the Amazon S3 bucket to contain the output of the media analysis job.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for storage.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig = MediaAnalysisOutputConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
