// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class ListDatasetEntriesRequest private constructor(builder: Builder) {
    /**
     * Specifies a label filter for the response. The response includes an entry only if one or more of the labels in `ContainsLabels` exist in the entry.
     */
    public val containsLabels: List<String>? = builder.containsLabels
    /**
     * The Amazon Resource Name (ARN) for the dataset that you want to use.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * Specifies an error filter for the response. Specify `True` to only include entries that have errors.
     */
    public val hasErrors: kotlin.Boolean? = builder.hasErrors
    /**
     * Specify `true` to get only the JSON Lines where the image is labeled. Specify `false` to get only the JSON Lines where the image isn't labeled. If you don't specify `Labeled`, `ListDatasetEntries` returns JSON Lines for labeled and unlabeled images.
     */
    public val labeled: kotlin.Boolean? = builder.labeled
    /**
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If specified, `ListDatasetEntries` only returns JSON Lines where the value of `SourceRefContains` is part of the `source-ref` field. The `source-ref` field contains the Amazon S3 location of the image. You can use `SouceRefContains` for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.
     */
    public val sourceRefContains: kotlin.String? = builder.sourceRefContains

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDatasetEntriesRequest(")
        append("containsLabels=$containsLabels,")
        append("datasetArn=$datasetArn,")
        append("hasErrors=$hasErrors,")
        append("labeled=$labeled,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sourceRefContains=$sourceRefContains")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containsLabels?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (hasErrors?.hashCode() ?: 0)
        result = 31 * result + (labeled?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sourceRefContains?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDatasetEntriesRequest

        if (containsLabels != other.containsLabels) return false
        if (datasetArn != other.datasetArn) return false
        if (hasErrors != other.hasErrors) return false
        if (labeled != other.labeled) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sourceRefContains != other.sourceRefContains) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a label filter for the response. The response includes an entry only if one or more of the labels in `ContainsLabels` exist in the entry.
         */
        public var containsLabels: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the dataset that you want to use.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * Specifies an error filter for the response. Specify `True` to only include entries that have errors.
         */
        public var hasErrors: kotlin.Boolean? = null
        /**
         * Specify `true` to get only the JSON Lines where the image is labeled. Specify `false` to get only the JSON Lines where the image isn't labeled. If you don't specify `Labeled`, `ListDatasetEntries` returns JSON Lines for labeled and unlabeled images.
         */
        public var labeled: kotlin.Boolean? = null
        /**
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * If specified, `ListDatasetEntries` only returns JSON Lines where the value of `SourceRefContains` is part of the `source-ref` field. The `source-ref` field contains the Amazon S3 location of the image. You can use `SouceRefContains` for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.
         */
        public var sourceRefContains: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesRequest) : this() {
            this.containsLabels = x.containsLabels
            this.datasetArn = x.datasetArn
            this.hasErrors = x.hasErrors
            this.labeled = x.labeled
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sourceRefContains = x.sourceRefContains
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesRequest = ListDatasetEntriesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
