// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class IndexFacesResponse private constructor(builder: Builder) {
    /**
     * The version number of the face detection model that's associated with the input collection (`CollectionId`).
     */
    public val faceModelVersion: kotlin.String? = builder.faceModelVersion
    /**
     * An array of faces detected and added to the collection. For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     */
    public val faceRecords: List<FaceRecord>? = builder.faceRecords
    /**
     * If your collection is associated with a face detection model that's later than version 3.0, the value of `OrientationCorrection` is always null and no orientation information is returned.
     *
     * If your collection is associated with a face detection model that's version 3.0 or earlier, the following applies:
     * + If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction - the bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata. The value of `OrientationCorrection` is null.
     * + If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image correction for images. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
     *
     * Bounding box information is returned in the `FaceRecords` array. You can get the version of the face detection model by calling DescribeCollection.
     */
    public val orientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = builder.orientationCorrection
    /**
     * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the quality filter identified them as low quality, or the `MaxFaces` request parameter filtered them out. To use the quality filter, you specify the `QualityFilter` request parameter.
     */
    public val unindexedFaces: List<UnindexedFace>? = builder.unindexedFaces

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.IndexFacesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexFacesResponse(")
        append("faceModelVersion=$faceModelVersion,")
        append("faceRecords=$faceRecords,")
        append("orientationCorrection=$orientationCorrection,")
        append("unindexedFaces=$unindexedFaces")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = faceModelVersion?.hashCode() ?: 0
        result = 31 * result + (faceRecords?.hashCode() ?: 0)
        result = 31 * result + (orientationCorrection?.hashCode() ?: 0)
        result = 31 * result + (unindexedFaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexFacesResponse

        if (faceModelVersion != other.faceModelVersion) return false
        if (faceRecords != other.faceRecords) return false
        if (orientationCorrection != other.orientationCorrection) return false
        if (unindexedFaces != other.unindexedFaces) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.IndexFacesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The version number of the face detection model that's associated with the input collection (`CollectionId`).
         */
        public var faceModelVersion: kotlin.String? = null
        /**
         * An array of faces detected and added to the collection. For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
         */
        public var faceRecords: List<FaceRecord>? = null
        /**
         * If your collection is associated with a face detection model that's later than version 3.0, the value of `OrientationCorrection` is always null and no orientation information is returned.
         *
         * If your collection is associated with a face detection model that's version 3.0 or earlier, the following applies:
         * + If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction - the bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata. The value of `OrientationCorrection` is null.
         * + If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image correction for images. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
         *
         * Bounding box information is returned in the `FaceRecords` array. You can get the version of the face detection model by calling DescribeCollection.
         */
        public var orientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = null
        /**
         * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the quality filter identified them as low quality, or the `MaxFaces` request parameter filtered them out. To use the quality filter, you specify the `QualityFilter` request parameter.
         */
        public var unindexedFaces: List<UnindexedFace>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.IndexFacesResponse) : this() {
            this.faceModelVersion = x.faceModelVersion
            this.faceRecords = x.faceRecords
            this.orientationCorrection = x.orientationCorrection
            this.unindexedFaces = x.unindexedFaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.IndexFacesResponse = IndexFacesResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
