// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMediaAnalysisJobResponse private constructor(builder: Builder) {
    /**
     * The Unix date and time when the job finished.
     */
    public val completionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTimestamp
    /**
     * The Unix date and time when the job was started.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTimestamp) { "A non-null value must be provided for creationTimestamp" }
    /**
     * Details about the error that resulted in failure of the job.
     */
    public val failureDetails: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails? = builder.failureDetails
    /**
     * Reference to the input manifest that was provided in the job creation request.
     */
    public val input: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput? = builder.input
    /**
     * The identifier for the media analysis job.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * The name of the media analysis job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * KMS Key that was provided in the creation request.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The summary manifest provides statistics on input manifest and errors identified in the input manifest.
     */
    public val manifestSummary: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary? = builder.manifestSummary
    /**
     * Operation configurations that were provided during job creation.
     */
    public val operationsConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig? = builder.operationsConfig
    /**
     * Output configuration that was provided in the creation request.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig? = builder.outputConfig
    /**
     * Output manifest that contains prediction results.
     */
    public val results: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults? = builder.results
    /**
     * The current status of the media analysis job.
     */
    public val status: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.GetMediaAnalysisJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMediaAnalysisJobResponse(")
        append("completionTimestamp=$completionTimestamp,")
        append("creationTimestamp=$creationTimestamp,")
        append("failureDetails=$failureDetails,")
        append("input=$input,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("kmsKeyId=$kmsKeyId,")
        append("manifestSummary=$manifestSummary,")
        append("operationsConfig=$operationsConfig,")
        append("outputConfig=$outputConfig,")
        append("results=$results,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTimestamp?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp.hashCode())
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (manifestSummary?.hashCode() ?: 0)
        result = 31 * result + (operationsConfig?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (results?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMediaAnalysisJobResponse

        if (completionTimestamp != other.completionTimestamp) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (failureDetails != other.failureDetails) return false
        if (input != other.input) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (manifestSummary != other.manifestSummary) return false
        if (operationsConfig != other.operationsConfig) return false
        if (outputConfig != other.outputConfig) return false
        if (results != other.results) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.GetMediaAnalysisJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unix date and time when the job finished.
         */
        public var completionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix date and time when the job was started.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about the error that resulted in failure of the job.
         */
        public var failureDetails: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails? = null
        /**
         * Reference to the input manifest that was provided in the job creation request.
         */
        public var input: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput? = null
        /**
         * The identifier for the media analysis job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The name of the media analysis job.
         */
        public var jobName: kotlin.String? = null
        /**
         * KMS Key that was provided in the creation request.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The summary manifest provides statistics on input manifest and errors identified in the input manifest.
         */
        public var manifestSummary: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary? = null
        /**
         * Operation configurations that were provided during job creation.
         */
        public var operationsConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig? = null
        /**
         * Output configuration that was provided in the creation request.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig? = null
        /**
         * Output manifest that contains prediction results.
         */
        public var results: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults? = null
        /**
         * The current status of the media analysis job.
         */
        public var status: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.GetMediaAnalysisJobResponse) : this() {
            this.completionTimestamp = x.completionTimestamp
            this.creationTimestamp = x.creationTimestamp
            this.failureDetails = x.failureDetails
            this.input = x.input
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.kmsKeyId = x.kmsKeyId
            this.manifestSummary = x.manifestSummary
            this.operationsConfig = x.operationsConfig
            this.outputConfig = x.outputConfig
            this.results = x.results
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.GetMediaAnalysisJobResponse = GetMediaAnalysisJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisJobFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary] inside the given [block]
         */
        public fun manifestSummary(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary.Builder.() -> kotlin.Unit) {
            this.manifestSummary = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisManifestSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig] inside the given [block]
         */
        public fun operationsConfig(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig.Builder.() -> kotlin.Unit) {
            this.operationsConfig = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults] inside the given [block]
         */
        public fun results(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults.Builder.() -> kotlin.Unit) {
            this.results = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisResults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTimestamp == null) creationTimestamp = Instant.fromEpochSeconds(0)
            if (jobId == null) jobId = ""
            if (status == null) status = MediaAnalysisJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
