// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Contains filters for the object labels returned by DetectLabels. Filters can be inclusive, exclusive, or a combination of both and can be applied to individual labels or entire label categories. To see a list of label categories, see [Detecting Labels](https://docs.aws.amazon.com/rekognition/latest/dg/labels.html).
 */
public class GeneralLabelsSettings private constructor(builder: Builder) {
    /**
     * The label categories that should be excluded from the return from DetectLabels.
     */
    public val labelCategoryExclusionFilters: List<String>? = builder.labelCategoryExclusionFilters
    /**
     * The label categories that should be included in the return from DetectLabels.
     */
    public val labelCategoryInclusionFilters: List<String>? = builder.labelCategoryInclusionFilters
    /**
     * The labels that should be excluded from the return from DetectLabels.
     */
    public val labelExclusionFilters: List<String>? = builder.labelExclusionFilters
    /**
     * The labels that should be included in the return from DetectLabels.
     */
    public val labelInclusionFilters: List<String>? = builder.labelInclusionFilters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.GeneralLabelsSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeneralLabelsSettings(")
        append("labelCategoryExclusionFilters=$labelCategoryExclusionFilters,")
        append("labelCategoryInclusionFilters=$labelCategoryInclusionFilters,")
        append("labelExclusionFilters=$labelExclusionFilters,")
        append("labelInclusionFilters=$labelInclusionFilters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = labelCategoryExclusionFilters?.hashCode() ?: 0
        result = 31 * result + (labelCategoryInclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (labelExclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (labelInclusionFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeneralLabelsSettings

        if (labelCategoryExclusionFilters != other.labelCategoryExclusionFilters) return false
        if (labelCategoryInclusionFilters != other.labelCategoryInclusionFilters) return false
        if (labelExclusionFilters != other.labelExclusionFilters) return false
        if (labelInclusionFilters != other.labelInclusionFilters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.GeneralLabelsSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The label categories that should be excluded from the return from DetectLabels.
         */
        public var labelCategoryExclusionFilters: List<String>? = null
        /**
         * The label categories that should be included in the return from DetectLabels.
         */
        public var labelCategoryInclusionFilters: List<String>? = null
        /**
         * The labels that should be excluded from the return from DetectLabels.
         */
        public var labelExclusionFilters: List<String>? = null
        /**
         * The labels that should be included in the return from DetectLabels.
         */
        public var labelInclusionFilters: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.GeneralLabelsSettings) : this() {
            this.labelCategoryExclusionFilters = x.labelCategoryExclusionFilters
            this.labelCategoryInclusionFilters = x.labelCategoryInclusionFilters
            this.labelExclusionFilters = x.labelExclusionFilters
            this.labelInclusionFilters = x.labelInclusionFilters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.GeneralLabelsSettings = GeneralLabelsSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
