// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * The evaluation results for the training of a model.
 */
public class EvaluationResult private constructor(builder: Builder) {
    /**
     * The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly.
     */
    public val f1Score: kotlin.Float? = builder.f1Score
    /**
     * The S3 bucket that contains the training summary.
     */
    public val summary: aws.sdk.kotlin.services.rekognition.model.Summary? = builder.summary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.EvaluationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationResult(")
        append("f1Score=$f1Score,")
        append("summary=$summary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = f1Score?.hashCode() ?: 0
        result = 31 * result + (summary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationResult

        if (f1Score != other.f1Score) return false
        if (summary != other.summary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.EvaluationResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly.
         */
        public var f1Score: kotlin.Float? = null
        /**
         * The S3 bucket that contains the training summary.
         */
        public var summary: aws.sdk.kotlin.services.rekognition.model.Summary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.EvaluationResult) : this() {
            this.f1Score = x.f1Score
            this.summary = x.summary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.EvaluationResult = EvaluationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Summary] inside the given [block]
         */
        public fun summary(block: aws.sdk.kotlin.services.rekognition.model.Summary.Builder.() -> kotlin.Unit) {
            this.summary = aws.sdk.kotlin.services.rekognition.model.Summary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
