// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class DetectCustomLabelsRequest private constructor(builder: Builder) {
    /**
     * Provides the input image either as bytes or an S3 object.
     *
     * You pass image bytes to an Amazon Rekognition API operation by using the `Bytes` property. For example, you would use the `Bytes` property to pass an image loaded from a local file system. Image bytes passed by using the `Bytes` property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations.
     *
     * For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.
     *
     *  You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the `S3Object` property. Images stored in an S3 bucket do not need to be base64-encoded.
     *
     * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
     *
     * If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.
     *
     * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image
    /**
     * Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Specifies the minimum confidence level for the labels to return. `DetectCustomLabels` doesn't return any labels with a confidence value that's lower than this specified value. If you specify a value of 0, `DetectCustomLabels` returns all labels, regardless of the assumed threshold applied to each label. If you don't specify a value for `MinConfidence`, `DetectCustomLabels` returns labels based on the assumed threshold of each label.
     */
    public val minConfidence: kotlin.Float? = builder.minConfidence
    /**
     * The ARN of the model version that you want to use. Only models associated with Custom Labels projects accepted by the operation. If a provided ARN refers to a model version associated with a project for a different feature type, then an InvalidParameterException is returned.
     */
    public val projectVersionArn: kotlin.String? = builder.projectVersionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DetectCustomLabelsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectCustomLabelsRequest(")
        append("image=$image,")
        append("maxResults=$maxResults,")
        append("minConfidence=$minConfidence,")
        append("projectVersionArn=$projectVersionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = image?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (minConfidence?.hashCode() ?: 0)
        result = 31 * result + (projectVersionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectCustomLabelsRequest

        if (image != other.image) return false
        if (maxResults != other.maxResults) return false
        if (minConfidence != other.minConfidence) return false
        if (projectVersionArn != other.projectVersionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DetectCustomLabelsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the input image either as bytes or an S3 object.
         *
         * You pass image bytes to an Amazon Rekognition API operation by using the `Bytes` property. For example, you would use the `Bytes` property to pass an image loaded from a local file system. Image bytes passed by using the `Bytes` property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations.
         *
         * For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.
         *
         *  You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the `S3Object` property. Images stored in an S3 bucket do not need to be base64-encoded.
         *
         * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
         *
         * If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.
         *
         * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Specifies the minimum confidence level for the labels to return. `DetectCustomLabels` doesn't return any labels with a confidence value that's lower than this specified value. If you specify a value of 0, `DetectCustomLabels` returns all labels, regardless of the assumed threshold applied to each label. If you don't specify a value for `MinConfidence`, `DetectCustomLabels` returns labels based on the assumed threshold of each label.
         */
        public var minConfidence: kotlin.Float? = null
        /**
         * The ARN of the model version that you want to use. Only models associated with Custom Labels projects accepted by the operation. If a provided ARN refers to a model version associated with a project for a different feature type, then an InvalidParameterException is returned.
         */
        public var projectVersionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DetectCustomLabelsRequest) : this() {
            this.image = x.image
            this.maxResults = x.maxResults
            this.minConfidence = x.minConfidence
            this.projectVersionArn = x.projectVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DetectCustomLabelsRequest = DetectCustomLabelsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
